/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.synctoken;

import com.atlassian.connect.spring.internal.jwt.CanonicalHttpRequest;
import com.atlassian.connect.spring.internal.jwt.HttpRequestCanonicalizer;
import com.atlassian.connect.spring.internal.jwt.JwtExpiredException;
import com.atlassian.connect.spring.internal.jwt.JwtParseException;
import com.atlassian.connect.spring.internal.jwt.JwtParser;
import com.atlassian.connect.spring.internal.jwt.JwtVerificationException;
import com.atlassian.connect.spring.internal.jwt.SymmetricJwtReader;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.marvelution.jji.synctoken.exceptions.InvalidSyncTokenException;
import org.marvelution.jji.synctoken.exceptions.SyncTokenExpiredException;
import org.marvelution.jji.synctoken.exceptions.SyncTokenRequiredException;
import org.marvelution.jji.synctoken.exceptions.UnknownSyncTokenIssuerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@javax.inject.Named
public class SyncTokenAuthenticator {
    public static final String OLD_SYNC_TOKEN_HEADER_NAME = "X-JJI-Sync-Token";
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncTokenAuthenticator.class);
    private final SharedSecretProvider sharedSecretProvider;

    @Inject
    @javax.inject.Inject
    public SyncTokenAuthenticator(SharedSecretProvider sharedSecretProvider) {
        this.sharedSecretProvider = sharedSecretProvider;
    }

    public JWTClaimsSet authenticate(Request request) {
        return this.authenticate(Optional.ofNullable(request.getSyncToken()).filter(StringUtils::isNotBlank).orElseThrow(SyncTokenRequiredException::new), request.getCanonicalHttpRequest());
    }

    public JWTClaimsSet authenticate(String token, CanonicalHttpRequest request) {
        LOGGER.debug("Authenticating request {}", (Object)request);
        try {
            return this.authenticate(token, HttpRequestCanonicalizer.computeCanonicalRequestHash((CanonicalHttpRequest)request));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidSyncTokenException("Unsupported token encoding", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidSyncTokenException("Unsupported token algorithm", e);
        }
    }

    private JWTClaimsSet authenticate(String token, String queryStringHash) {
        try {
            JWTClaimsSet unverifiedClaims = new JwtParser().parse(token);
            String sharedSecret = this.sharedSecretProvider.getSharedSecretForIssuer(unverifiedClaims.getIssuer()).orElseThrow(() -> new UnknownSyncTokenIssuerException(unverifiedClaims));
            return new SymmetricJwtReader(new MACVerifier(sharedSecret)).readAndVerify(token, queryStringHash);
        }
        catch (JwtExpiredException e) {
            LOGGER.error(e.getMessage());
            throw new SyncTokenExpiredException(e.getMessage(), e);
        }
        catch (JwtParseException | JwtVerificationException | JOSEException e) {
            LOGGER.error(e.getMessage());
            throw new InvalidSyncTokenException(e.getMessage(), e);
        }
    }

    public static abstract class Request {
        public String getSyncToken() {
            return Optional.ofNullable(this.getHeader("X-Sync-Token")).orElseGet(() -> this.getHeader(SyncTokenAuthenticator.OLD_SYNC_TOKEN_HEADER_NAME));
        }

        @Nullable
        protected abstract String getHeader(String var1);

        public abstract CanonicalHttpRequest getCanonicalHttpRequest();
    }

    public static interface SharedSecretProvider {
        public Optional<String> getSharedSecretForIssuer(String var1);
    }
}

