/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.configuration;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.Secret;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;
import org.marvelution.jji.configuration.JiraSite;
import org.springframework.security.core.Authentication;

@Extension
@Symbol(value={"jira-integration-configuration"})
public class JiraSitesConfiguration
extends GlobalConfiguration {
    static final String ID = "jira-integration-configuration";
    private static final Logger LOGGER = Logger.getLogger(JiraSitesConfiguration.class.getName());
    private Set<JiraSite> sites = new CopyOnWriteArraySet<JiraSite>();

    public JiraSitesConfiguration() {
        this.load();
    }

    public boolean configure(StaplerRequest req, JSONObject json) {
        return true;
    }

    public Set<JiraSite> getSites() {
        return this.sites;
    }

    @DataBoundSetter
    public void setSites(Set<JiraSite> sites) {
        this.sites = sites;
    }

    public Stream<JiraSite> stream() {
        return this.sites.stream();
    }

    public Optional<JiraSite> findSite(URI uri) {
        return this.sites.stream().filter(site -> Objects.equals(site.getUri(), uri)).findFirst();
    }

    public Optional<JiraSite> findSite(String identifier) {
        return this.sites.stream().filter(site -> Objects.equals(site.getIdentifier(), identifier)).findFirst();
    }

    public void registerSite(JiraSite site) {
        Optional<JiraSite> existing = this.getExistingSite(site.getUri());
        if (existing.isPresent()) {
            LOGGER.log(Level.INFO, "Updating registration for {0}", site);
            this.updateSiteRegistration(existing.get(), site);
        } else {
            LOGGER.log(Level.INFO, "Adding registration for {0}", site);
            this.storeSharedSecretAsCredentials(site);
            this.sites.add(site);
        }
        this.save();
    }

    private void updateSiteRegistration(JiraSite existing, JiraSite newSite) {
        existing.setName(newSite.getName());
        existing.setIdentifier(newSite.getIdentifier());
        existing.setPostJson(newSite.isPostJson());
        this.updateSharedSecretCredentials(existing, newSite);
    }

    public void unregisterSite(JiraSite site) {
        this.removeSharedSecretCredentials(site);
        this.sites.remove(site);
        this.save();
        LOGGER.log(Level.INFO, "Unregistered Jira Site at: {0}", site.getUri());
    }

    private void storeSharedSecretAsCredentials(JiraSite site) {
        StringCredentials credentials = this.createSharedSecretCredentials(site, null);
        try (ACLContext ignored = ACL.as2((Authentication)ACL.SYSTEM2);){
            new SystemCredentialsProvider.StoreImpl().addDomain(site.getDomain(), new Credentials[]{credentials});
            site.setSharedSecretId(credentials.getId());
            site.setSharedSecret(null);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to store shared secret credentials for " + String.valueOf(site), e);
        }
    }

    private void updateSharedSecretCredentials(JiraSite existing, JiraSite site) {
        if (Objects.equals(existing.getDomain(), site.getDomain())) {
            existing.getSharedSecretCredentials().ifPresent(credentials -> {
                try (ACLContext ignored = ACL.as2((Authentication)ACL.SYSTEM2);){
                    StringCredentials newCredentials = this.createSharedSecretCredentials(site, credentials.getId());
                    new SystemCredentialsProvider.StoreImpl().updateCredentials(existing.getDomain(), (Credentials)credentials, (Credentials)newCredentials);
                    existing.setSharedSecretId(newCredentials.getId());
                    existing.setSharedSecret(null);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to store shared secret credentials for " + String.valueOf(site), e);
                }
            });
        } else {
            this.removeSharedSecretCredentials(existing);
            this.storeSharedSecretAsCredentials(site);
            existing.setSharedSecretId(site.getSharedSecretId());
            existing.setSharedSecret(site.getSharedSecret());
        }
    }

    private void removeSharedSecretCredentials(JiraSite site) {
        site.getSharedSecretCredentials().ifPresent(credentials -> {
            try (ACLContext ignored = ACL.as2((Authentication)ACL.SYSTEM2);){
                new SystemCredentialsProvider.StoreImpl().removeCredentials(site.getDomain(), (Credentials)credentials);
                site.setSharedSecretId(null);
                site.setSharedSecret(credentials.getSecret().getPlainText());
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to store shared secret credentials for " + String.valueOf(site), e);
            }
        });
    }

    @Nonnull
    private StringCredentials createSharedSecretCredentials(JiraSite site, @Nullable String id) {
        String description = String.format("Jira Integration (%s) auto generated shared secret credentials", site.getName());
        return new StringCredentialsImpl(CredentialsScope.GLOBAL, id != null ? id : UUID.randomUUID().toString(), description, Secret.fromString((String)site.getSharedSecret()));
    }

    @Nonnull
    private Optional<JiraSite> getExistingSite(URI uri) {
        return this.sites.stream().filter(site -> site.getUri().equals(uri)).findFirst();
    }

    public String getDisplayName() {
        return "Jira Sites";
    }

    public String getId() {
        return ID;
    }

    @Initializer(after=InitMilestone.SYSTEM_CONFIG_ADAPTED)
    public void migrateSharedSecretsToCredentials() {
        boolean updated = false;
        for (JiraSite site : this.sites) {
            if (!StringUtils.isNotBlank((CharSequence)site.getSharedSecret()) || !StringUtils.isBlank((CharSequence)site.getSharedSecretId())) continue;
            this.storeSharedSecretAsCredentials(site);
            updated = true;
        }
        if (updated) {
            try {
                this.getConfigFile().write((Object)this);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to save " + String.valueOf(this.getConfigFile()), e);
            }
        }
    }

    public void updateSiteRegistrations(OkHttpClient httpClient) {
        for (JiraSite site : this.getSites()) {
            try {
                Response response = httpClient.newCall(site.createGetRegisterDetailsRequest()).execute();
                try {
                    ResponseBody body = response.body();
                    try {
                        LOGGER.log(Level.INFO, "Checking " + String.valueOf(site));
                        site.setLastStatus(response.code());
                        Optional.ofNullable(response.header("X-Registration-Status", "0")).map(header -> {
                            try {
                                return Integer.parseInt(header);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.log(Level.FINE, "Unexpected value returned for X-Registration-Status", e);
                                return 0;
                            }
                        }).ifPresent(status -> site.setUpToDate(status == 0));
                        if (response.isSuccessful() && body != null) {
                            JSONObject details = JSONObject.fromObject((Object)body.string());
                            LOGGER.log(Level.INFO, "Updating {0}", site);
                            site.updateSiteDetails(details);
                            continue;
                        }
                        if (response.code() == 402) {
                            LOGGER.log(Level.INFO, "Disabling " + String.valueOf(site) + " as payment is required");
                            continue;
                        }
                        LOGGER.log(Level.SEVERE, "Unable to update " + String.valueOf(site) + "; " + response.code());
                    }
                    finally {
                        if (body == null) continue;
                        body.close();
                    }
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to update " + String.valueOf(site), e);
                site.setLastStatus(-1);
            }
        }
        this.save();
    }

    public static JiraSitesConfiguration get() {
        return (JiraSitesConfiguration)Jenkins.get().getDescriptorOrDie(JiraSitesConfiguration.class);
    }
}

