/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.utils;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.marvelution.jji.model.Build;
import org.marvelution.jji.model.ChangeSet;
import org.marvelution.jji.model.Job;
import org.marvelution.jji.model.Site;

public final class KeyExtractor {
    private static final String SEPARATOR = "[\\s\\p{Punct}]";
    private static final String KEY_PREFIX_REGEX = "(?:(?<=[\\s\\p{Punct}])|^)";
    private static final String KEY_BODY_REGEX = "(((?:\\p{Lu}[\\p{Lu}\\p{Digit}_]+|\\p{Ll}[\\p{Ll}\\p{Digit}_]+))-\\p{Digit}+)";
    private static final String KEY_POSTFIX_REGEX = "(?:(?=[\\s\\p{Punct}])|$)";
    private static final String ISSUE_KEY_REGEX = "(?:(?<=[\\s\\p{Punct}])|^)(((?:\\p{Lu}[\\p{Lu}\\p{Digit}_]+|\\p{Ll}[\\p{Ll}\\p{Digit}_]+))-\\p{Digit}+)(?:(?=[\\s\\p{Punct}])|$)";
    private static final Pattern ISSUE_KEY_PATTERN = Pattern.compile("(?:(?<=[\\s\\p{Punct}])|^)(((?:\\p{Lu}[\\p{Lu}\\p{Digit}_]+|\\p{Ll}[\\p{Ll}\\p{Digit}_]+))-\\p{Digit}+)(?:(?=[\\s\\p{Punct}])|$)", 2);
    private static final Pattern PROJECT_KEY_PATTERN = Pattern.compile("(((?:\\p{Lu}[\\p{Lu}\\p{Digit}_]+|\\p{Ll}[\\p{Ll}\\p{Digit}_]+))-\\p{Digit}+)", 2);

    private KeyExtractor() {
    }

    public static Set<String> extractIssueKeys(Job job) {
        Set<String> issueKeys = KeyExtractor.extractIssueKeys(job.getDisplayName(), job.getDescription(), job.getUrlName());
        return KeyExtractor.limitByScope(job.getSite(), issueKeys);
    }

    public static Set<String> extractIssueKeys(Build build) {
        return KeyExtractor.extractIssueKeys(build, build.getJob());
    }

    public static Set<String> extractIssueKeys(Build build, Job job) {
        HashSet<String> issueKeys = new HashSet<String>();
        issueKeys.addAll(KeyExtractor.extractIssueKeys(job));
        issueKeys.addAll(KeyExtractor.extractIssueKeys(build.getDisplayName(), build.getDescription(), build.getCause()));
        for (String branch : build.getBranches()) {
            issueKeys.addAll(KeyExtractor.extractIssueKeys(branch));
        }
        for (ChangeSet changeSet : build.getChangeSet()) {
            issueKeys.addAll(KeyExtractor.extractIssueKeys(changeSet.getMessage()));
        }
        return KeyExtractor.limitByScope(job.getSite(), issueKeys);
    }

    private static Set<String> limitByScope(Site site, Set<String> issueKeys) {
        if (site != null && StringUtils.isNotBlank((CharSequence)site.getScope())) {
            String prefix = site.getScope() + "-";
            return issueKeys.stream().filter(key -> key.startsWith(prefix)).collect(Collectors.toSet());
        }
        return issueKeys;
    }

    public static Set<String> extractIssueKeys(String ... messages) {
        HashSet<String> matches = new HashSet<String>();
        if (messages != null && messages.length > 0) {
            for (String message : messages) {
                if (!StringUtils.isNotBlank((CharSequence)message)) continue;
                Matcher match = ISSUE_KEY_PATTERN.matcher(message);
                while (match.find()) {
                    matches.add(match.group(1).toUpperCase(Locale.ENGLISH));
                }
            }
        }
        return matches;
    }

    public static String extractProjectKeyFromIssueKey(String issueKey) {
        Matcher match = PROJECT_KEY_PATTERN.matcher(issueKey);
        if (match.find()) {
            return match.group(2);
        }
        if (issueKey.lastIndexOf(45) != -1) {
            return issueKey.substring(0, issueKey.lastIndexOf(45));
        }
        throw new IllegalArgumentException("'" + issueKey + "' is not a valid issue key");
    }
}

