/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model.response;

import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlRootElement;

@jakarta.xml.bind.annotation.XmlRootElement
@XmlAccessorType(value=jakarta.xml.bind.annotation.XmlAccessType.FIELD)
@XmlRootElement
@javax.xml.bind.annotation.XmlAccessorType(value=XmlAccessType.FIELD)
public class TriggerBuildsResponse {
    private List<Trigger> triggers;

    public List<Trigger> getTriggers() {
        if (this.triggers == null) {
            this.triggers = new ArrayList<Trigger>();
        }
        return this.triggers;
    }

    public TriggerBuildsResponse setTriggers(List<Trigger> triggers) {
        this.triggers = triggers;
        return this;
    }

    public boolean hasTriggers(Type type) {
        return this.getTriggers().stream().anyMatch(trigger -> ((Trigger)trigger).type == type);
    }

    public List<Trigger> getTriggers(Type type) {
        return this.getTriggers().stream().filter(trigger -> ((Trigger)trigger).type == type).collect(Collectors.toList());
    }

    public boolean hasFailures() {
        return this.hasTriggers(Type.ERROR);
    }

    public List<Trigger> getFailures() {
        return this.getTriggers(Type.ERROR);
    }

    public TriggerBuildsResponse addFailure(String message, @Nullable URI link) {
        this.getTriggers().add(new Trigger().setType(Type.ERROR).setMessage(message).setLink(link));
        return this;
    }

    public boolean hasWarnings() {
        return this.hasTriggers(Type.WARNING);
    }

    public List<Trigger> getWarnings() {
        return this.getTriggers(Type.WARNING);
    }

    public TriggerBuildsResponse addWarning(String message, @Nullable URI link) {
        this.getTriggers().add(new Trigger().setType(Type.WARNING).setMessage(message).setLink(link));
        return this;
    }

    public boolean hasSuccesses() {
        return this.hasTriggers(Type.SUCCESS);
    }

    public List<Trigger> getSuccesses() {
        return this.getTriggers(Type.SUCCESS);
    }

    public TriggerBuildsResponse addSuccess(String message, @Nullable URI link) {
        this.getTriggers().add(new Trigger().setType(Type.SUCCESS).setMessage(message).setLink(link));
        return this;
    }

    @jakarta.xml.bind.annotation.XmlRootElement
    @XmlAccessorType(value=jakarta.xml.bind.annotation.XmlAccessType.FIELD)
    @XmlRootElement
    @javax.xml.bind.annotation.XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Trigger {
        private Type type;
        private String message;
        private URI link;

        public Type getType() {
            return this.type;
        }

        public Trigger setType(Type type) {
            this.type = type;
            return this;
        }

        public String getMessage() {
            return this.message;
        }

        public Trigger setMessage(String message) {
            this.message = message;
            return this;
        }

        public URI getLink() {
            return this.link;
        }

        public Trigger setLink(URI link) {
            this.link = link;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Trigger trigger = (Trigger)o;
            return this.type == trigger.type && this.message.equals(trigger.message) && Objects.equals(this.link, trigger.link);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.message, this.link});
        }

        public String toString() {
            return new StringJoiner(", ", Trigger.class.getSimpleName() + "[", "]").add("type=" + (Object)((Object)this.type)).add("message='" + this.message + "'").add("link=" + this.link).toString();
        }
    }

    @XmlEnum
    @XmlType
    @javax.xml.bind.annotation.XmlEnum
    @javax.xml.bind.annotation.XmlType
    public static enum Type {
        SUCCESS,
        WARNING,
        ERROR;

    }
}

