/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model.request;

import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@jakarta.xml.bind.annotation.XmlRootElement
@XmlAccessorType(value=jakarta.xml.bind.annotation.XmlAccessType.FIELD)
@XmlRootElement
@javax.xml.bind.annotation.XmlAccessorType(value=XmlAccessType.FIELD)
public class TriggerBuildsRequest {
    public static final String LINKED = JobSelector.linked.name();
    public static final String BY_CONVENTION = JobSelector.byConvention.name();
    public static final String BY_ISSUE_FIELD = JobSelector.byIssueField.name();
    public static final String SPECIFIC_JOB = JobSelector.specificJob.name();
    public static final String BY_ISSUE_FIELD_PREFIX = BY_ISSUE_FIELD + "::";
    private String issueKey;
    private JobSelector jobSelector;
    private String byIssueField;
    private String byIssueFieldMapping;
    private Set<String> jobs;
    private String lookupJob;
    private UseParameters useParameters;
    private Set<Parameter> parameters;

    public String getIssueKey() {
        return this.issueKey;
    }

    public TriggerBuildsRequest setIssueKey(String issueKey) {
        this.issueKey = issueKey;
        return this;
    }

    public JobSelector getJobSelector() {
        return this.jobSelector;
    }

    public TriggerBuildsRequest setJobSelector(JobSelector jobSelector) {
        this.jobSelector = jobSelector;
        return this;
    }

    public boolean isLinked() {
        return this.jobSelector == JobSelector.linked;
    }

    public TriggerBuildsRequest setLinked() {
        this.jobSelector = JobSelector.linked;
        return this;
    }

    public boolean isByConvention() {
        return this.jobSelector == JobSelector.byConvention;
    }

    public TriggerBuildsRequest setByConvention() {
        this.jobSelector = JobSelector.byConvention;
        return this;
    }

    public boolean isByIssueField() {
        return this.jobSelector == JobSelector.byIssueField && this.byIssueField != null;
    }

    public String getByIssueField() {
        return this.byIssueField;
    }

    public TriggerBuildsRequest setByIssueField(String byIssueField) {
        this.jobSelector = JobSelector.byIssueField;
        this.byIssueField = byIssueField;
        return this;
    }

    public String getByIssueFieldMapping() {
        return this.byIssueFieldMapping;
    }

    public TriggerBuildsRequest setByIssueFieldMapping(String byIssueFieldMapping) {
        this.byIssueFieldMapping = byIssueFieldMapping;
        return this;
    }

    public boolean isSpecificJob() {
        return this.jobSelector == JobSelector.specificJob && this.jobs != null && !this.jobs.isEmpty();
    }

    public Set<String> getJobs() {
        if (this.jobs == null) {
            this.jobs = new HashSet<String>();
        }
        return this.jobs;
    }

    public TriggerBuildsRequest setJobs(Set<String> jobs) {
        this.jobSelector = JobSelector.specificJob;
        this.jobs = jobs;
        return this;
    }

    public boolean isLookupJob() {
        return this.jobSelector == JobSelector.lookupJob && this.lookupJob != null;
    }

    public String getLookupJob() {
        return this.lookupJob;
    }

    public TriggerBuildsRequest setLookupJob(String lookupJob) {
        this.jobSelector = JobSelector.lookupJob;
        this.lookupJob = lookupJob;
        return this;
    }

    public UseParameters getUseParameters() {
        return this.useParameters == null ? UseParameters.reference : this.useParameters;
    }

    public TriggerBuildsRequest setUseParameters(UseParameters useParameters) {
        this.useParameters = useParameters;
        return this;
    }

    public Set<Parameter> getParameters() {
        return this.parameters;
    }

    public TriggerBuildsRequest setParameters(Set<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public TriggerBuildsRequest addParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new HashSet<Parameter>();
        }
        this.parameters.add(new Parameter().setName(name).setValue(value));
        return this;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.issueKey, this.jobSelector, this.byIssueField, this.byIssueFieldMapping, this.jobs, this.lookupJob, this.useParameters, this.parameters});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TriggerBuildsRequest)) {
            return false;
        }
        TriggerBuildsRequest that = (TriggerBuildsRequest)o;
        return Objects.equals(this.issueKey, that.issueKey) && this.jobSelector == that.jobSelector && Objects.equals(this.byIssueField, that.byIssueField) && Objects.equals(this.byIssueFieldMapping, that.byIssueFieldMapping) && Objects.equals(this.jobs, that.jobs) && Objects.equals(this.lookupJob, that.lookupJob) && this.useParameters == that.useParameters && Objects.equals(this.parameters, that.parameters);
    }

    public String toString() {
        return new StringJoiner(", ", TriggerBuildsRequest.class.getSimpleName() + "[", "]").add("issueKey='" + this.issueKey + "'").add("jobSelector=" + (Object)((Object)this.jobSelector)).add("byIssueField='" + this.byIssueField + "'").add("byIssueFieldMapping='" + this.byIssueFieldMapping + "'").add("jobs=" + this.jobs).add("lookupJob='" + this.lookupJob + "'").add("useParameters=" + (Object)((Object)this.useParameters)).add("parameters=" + this.parameters).toString();
    }

    public static TriggerBuildsRequest forPostFunction(String issueKey, String configuration) {
        TriggerBuildsRequest request = new TriggerBuildsRequest().setIssueKey(issueKey);
        if (LINKED.equalsIgnoreCase(configuration)) {
            request.setLinked();
        } else if (BY_CONVENTION.equalsIgnoreCase(configuration)) {
            request.setByConvention();
        } else if (TriggerBuildsRequest.isForSpecificJob(configuration)) {
            request.setJobs(Collections.singleton(configuration));
        } else if (TriggerBuildsRequest.isByIssueField(configuration)) {
            int dollar = configuration.indexOf("$");
            if (dollar > 0) {
                request.setByIssueField(configuration.substring(BY_ISSUE_FIELD_PREFIX.length(), dollar));
                request.setByIssueFieldMapping(configuration.substring(dollar));
            } else {
                request.setByIssueField(configuration.substring(BY_ISSUE_FIELD_PREFIX.length()));
            }
        }
        return request;
    }

    static boolean isForSpecificJob(String config) {
        return StringUtils.isNotBlank((CharSequence)config) && !TriggerBuildsRequest.isByIssueField(config) && !LINKED.equalsIgnoreCase(config) && !BY_CONVENTION.equalsIgnoreCase(config);
    }

    static boolean isByIssueField(String config) {
        return config != null && config.startsWith(BY_ISSUE_FIELD_PREFIX) && config.length() > BY_ISSUE_FIELD_PREFIX.length();
    }

    @jakarta.xml.bind.annotation.XmlRootElement
    @XmlAccessorType(value=jakarta.xml.bind.annotation.XmlAccessType.FIELD)
    @XmlRootElement
    @javax.xml.bind.annotation.XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Parameter {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public Parameter setName(String name) {
            this.name = name;
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public Parameter setValue(String value) {
            this.value = value;
            return this;
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter that = (Parameter)o;
            return Objects.equals(this.name, that.name);
        }

        public String toString() {
            return new StringJoiner(", ", Parameter.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("value=" + this.value).toString();
        }

        public static Parameter create(String name, String value) {
            return new Parameter().setName(name).setValue(value);
        }
    }

    @XmlEnum
    @XmlType
    @javax.xml.bind.annotation.XmlEnum
    @javax.xml.bind.annotation.XmlType
    public static enum UseParameters {
        reference,
        none,
        specified;

    }

    @XmlEnum
    @XmlType
    @javax.xml.bind.annotation.XmlEnum
    @javax.xml.bind.annotation.XmlType
    public static enum JobSelector {
        linked,
        byConvention,
        byIssueField,
        lookupJob,
        specificJob;

    }
}

