/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model;

import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

@jakarta.xml.bind.annotation.XmlRootElement
@XmlAccessorType(value=jakarta.xml.bind.annotation.XmlAccessType.FIELD)
@XmlRootElement
@javax.xml.bind.annotation.XmlAccessorType(value=XmlAccessType.FIELD)
public class Version
implements Comparable<Version> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+(\\.\\d+)*).*");
    @XmlElement
    @javax.xml.bind.annotation.XmlElement
    private final int major;
    @XmlElement
    @javax.xml.bind.annotation.XmlElement
    private final int minor;
    @XmlElement
    @javax.xml.bind.annotation.XmlElement
    private final int micro;

    public Version(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public static Version of(@Nonnull String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            String[] parts = StringUtils.split((String)matcher.group(1), (String)".");
            int major = parts.length > 0 ? NumberUtils.toInt((String)parts[0]) : 0;
            int minor = parts.length > 1 ? NumberUtils.toInt((String)parts[1]) : 0;
            int micro = parts.length > 2 ? NumberUtils.toInt((String)parts[2]) : 0;
            return new Version(major, minor, micro);
        }
        throw new IllegalArgumentException("Illegal version " + version);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public boolean isOlder(@Nonnull Version other) {
        return this.compareTo(other) < 0;
    }

    public boolean isNewer(@Nonnull Version other) {
        return this.compareTo(other) > 0;
    }

    @Override
    public int compareTo(@Nonnull Version other) {
        if (other == this) {
            return 0;
        }
        int diff = this.major - other.major;
        if (diff == 0 && (diff = this.minor - other.minor) == 0) {
            diff = this.micro - other.micro;
        }
        return diff;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.micro);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.micro == version.micro;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.micro;
    }
}

