/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model;

import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.marvelution.jji.model.HasId;
import org.marvelution.jji.model.Job;
import org.marvelution.jji.model.JobsContainer;
import org.marvelution.jji.model.OperationId;
import org.marvelution.jji.model.SiteAuthentication;
import org.marvelution.jji.model.SiteAuthenticationType;
import org.marvelution.jji.model.SiteConnectionType;
import org.marvelution.jji.model.SiteType;
import org.marvelution.jji.model.Syncable;
import org.marvelution.jji.model.adapters.javax.ObfuscateAdapter;

@XmlRootElement
@XmlAccessorType(value=jakarta.xml.bind.annotation.XmlAccessType.FIELD)
@javax.xml.bind.annotation.XmlRootElement
@javax.xml.bind.annotation.XmlAccessorType(value=XmlAccessType.FIELD)
public class Site
implements HasId<Site>,
JobsContainer,
Syncable<Site> {
    public static final String OPERATION_PREFIX = "site-sync";
    private String id;
    private String name;
    @XmlJavaTypeAdapter(value=org.marvelution.jji.model.adapters.ObfuscateAdapter.class)
    @javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter(value=ObfuscateAdapter.class)
    private String sharedSecret;
    private SiteType type;
    private URI rpcUrl;
    @jakarta.xml.bind.annotation.XmlTransient
    @XmlTransient
    private URI displayUrl;
    @jakarta.xml.bind.annotation.XmlElement(name="authentication")
    @XmlElement(name="authentication")
    private SiteAuthenticationType authenticationType;
    private String user;
    @XmlJavaTypeAdapter(value=org.marvelution.jji.model.adapters.ObfuscateAdapter.class)
    @javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter(value=ObfuscateAdapter.class)
    private String token;
    @XmlJavaTypeAdapter(value=org.marvelution.jji.model.adapters.ObfuscateAdapter.class)
    @javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter(value=ObfuscateAdapter.class)
    private String newToken;
    private boolean useCrumbs;
    private boolean jenkinsPluginInstalled;
    private boolean registrationComplete;
    private boolean autoLinkNewJobs;
    private boolean hasJobs;
    private boolean hasDeletedJobs;
    @jakarta.xml.bind.annotation.XmlElement(name="connection")
    @XmlElement(name="connection")
    private SiteConnectionType connectionType = SiteConnectionType.ACCESSIBLE;
    private boolean enabled = true;
    private String scope;
    private List<Job> jobs;

    @Override
    public Site copy() {
        Site site = new Site();
        site.id = this.id;
        site.name = this.name;
        site.sharedSecret = this.sharedSecret;
        site.type = this.type;
        site.rpcUrl = Site.checkTrailingSlash(this.rpcUrl);
        site.displayUrl = Site.checkTrailingSlash(this.displayUrl);
        site.authenticationType = this.authenticationType;
        site.user = this.user;
        site.token = this.token;
        site.newToken = this.newToken;
        site.useCrumbs = this.useCrumbs;
        site.jenkinsPluginInstalled = this.jenkinsPluginInstalled;
        site.registrationComplete = this.registrationComplete;
        site.autoLinkNewJobs = this.autoLinkNewJobs;
        site.hasJobs = this.hasJobs;
        site.hasDeletedJobs = this.hasDeletedJobs;
        site.connectionType = this.connectionType;
        site.enabled = this.enabled;
        site.scope = this.scope;
        return site;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Site setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Site setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @jakarta.xml.bind.annotation.XmlTransient
    @XmlTransient
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public OperationId getOperationId() {
        return OperationId.of(OPERATION_PREFIX, this.id);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public Site setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public Site setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
        return this;
    }

    public SiteType getType() {
        return this.type;
    }

    public Site setType(SiteType type) {
        this.type = type;
        return this;
    }

    public SiteAuthentication getAuthentication() {
        return this.usesBasicAuthentication() ? new SiteAuthentication.BasicSiteAuthentication(this.user, this.token) : new SiteAuthentication.SyncTokenSiteAuthentication();
    }

    public SiteAuthenticationType getAuthenticationType() {
        if (this.authenticationType == null) {
            this.authenticationType = StringUtils.isNotBlank((CharSequence)this.user) && StringUtils.isNotBlank((CharSequence)this.token) ? SiteAuthenticationType.BASIC : SiteAuthenticationType.TOKEN;
        }
        return this.authenticationType;
    }

    public Site setAuthenticationType(SiteAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    public Site setUser(@Nullable String user) {
        this.user = (String)StringUtils.defaultIfBlank((CharSequence)user, null);
        return this;
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    public Site setToken(@Nullable String token) {
        this.token = (String)StringUtils.defaultIfBlank((CharSequence)token, null);
        return this;
    }

    public boolean usesBasicAuthentication() {
        return this.getAuthenticationType() == SiteAuthenticationType.BASIC;
    }

    public boolean usesTokenAuthentication() {
        return this.getAuthenticationType() == SiteAuthenticationType.TOKEN;
    }

    public boolean usesAuthentication(SiteAuthenticationType authentication) {
        return this.getAuthenticationType() == authentication;
    }

    public String getNewToken() {
        return this.newToken;
    }

    public Site setNewToken(String newToken) {
        this.newToken = newToken;
        return this;
    }

    public URI getRpcUrl() {
        return this.rpcUrl;
    }

    public Site setRpcUrl(URI rpcUrl) {
        this.rpcUrl = Site.checkTrailingSlash(rpcUrl);
        return this;
    }

    @jakarta.xml.bind.annotation.XmlElement
    @XmlElement
    public URI getDisplayUrl() {
        return this.displayUrl != null ? this.displayUrl : this.rpcUrl;
    }

    public Site setDisplayUrl(@Nullable URI displayUrl) {
        this.displayUrl = Optional.ofNullable(displayUrl).map(Site::checkTrailingSlash).filter(url -> !url.equals(this.rpcUrl)).orElse(null);
        return this;
    }

    @Nullable
    public URI getDisplayUrlOrNull() {
        return this.displayUrl;
    }

    public boolean isUseCrumbs() {
        return this.useCrumbs;
    }

    public Site setUseCrumbs(boolean useCrumbs) {
        this.useCrumbs = useCrumbs;
        return this;
    }

    public boolean isJenkinsPluginInstalled() {
        return this.jenkinsPluginInstalled;
    }

    public Site setJenkinsPluginInstalled(boolean jenkinsPluginInstalled) {
        this.jenkinsPluginInstalled = jenkinsPluginInstalled;
        return this;
    }

    public boolean isRegistrationComplete() {
        return this.registrationComplete;
    }

    public Site setRegistrationComplete(boolean registrationComplete) {
        this.registrationComplete = registrationComplete;
        return this;
    }

    public boolean isAutoLinkNewJobs() {
        return this.autoLinkNewJobs;
    }

    public Site setAutoLinkNewJobs(boolean autoLinkNewJobs) {
        this.autoLinkNewJobs = autoLinkNewJobs;
        return this;
    }

    public Site setHasJobs(boolean hasJobs) {
        this.hasJobs = hasJobs;
        return this;
    }

    public boolean hasDeletedJobs() {
        return this.getJobs().stream().anyMatch(Job::isDeleted) || this.hasDeletedJobs;
    }

    public Site setHasDeletedJobs(boolean hasDeletedJobs) {
        this.hasDeletedJobs = hasDeletedJobs;
        return this;
    }

    public SiteConnectionType getConnectionType() {
        return this.connectionType;
    }

    public Site setConnectionType(SiteConnectionType connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    public boolean usesConnectionType(SiteConnectionType type) {
        return this.connectionType == type;
    }

    public boolean isAccessibleSite() {
        return this.usesConnectionType(SiteConnectionType.ACCESSIBLE);
    }

    public Site setAccessibleSite() {
        this.setConnectionType(SiteConnectionType.ACCESSIBLE);
        return this;
    }

    public boolean isInaccessibleSite() {
        return this.usesConnectionType(SiteConnectionType.INACCESSIBLE);
    }

    public Site setInaccessibleSite() {
        this.setConnectionType(SiteConnectionType.INACCESSIBLE);
        return this;
    }

    public boolean isTunneledSite() {
        return this.usesConnectionType(SiteConnectionType.TUNNELED);
    }

    public Site setTunneledSite() {
        this.setConnectionType(SiteConnectionType.TUNNELED);
        return this;
    }

    @Override
    @jakarta.xml.bind.annotation.XmlTransient
    @XmlTransient
    public Site getSite() {
        return this;
    }

    @Override
    public List<Job> getJobs() {
        if (this.jobs == null) {
            this.jobs = new ArrayList<Job>();
        }
        return this.jobs;
    }

    public Site setJobs(List<Job> jobs) {
        this.jobs = jobs;
        return this;
    }

    @Override
    public boolean hasJobs() {
        return !this.getJobs().isEmpty() || this.hasJobs;
    }

    @Override
    public void addJob(Job job) {
        this.getJobs().add(job);
    }

    @Override
    public boolean shouldJobBeLinked(Job job) {
        return job.getId() == null && this.isAutoLinkNewJobs();
    }

    public String getScope() {
        return this.scope != null ? this.scope : "";
    }

    public Site setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Site site = (Site)o;
        return Objects.equals(this.id, site.id);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).append("scope", (Object)this.scope).append("name", (Object)this.name).append("rpcUrl", (Object)this.rpcUrl).append("useCrumbs", this.useCrumbs).append("jenkinsPluginInstalled", this.jenkinsPluginInstalled).append("autoLinkNewJobs", this.autoLinkNewJobs).toString();
    }

    @Nullable
    public static URI checkTrailingSlash(@Nullable URI uri) {
        if (uri != null) {
            return URI.create(StringUtils.stripEnd((String)uri.toASCIIString(), (String)"/") + "/");
        }
        return null;
    }
}

