/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model;

import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbPropertyOrder;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.marvelution.jji.model.Build;
import org.marvelution.jji.model.DeploymentEnvironment;
import org.marvelution.jji.model.DeploymentEnvironmentType;
import org.marvelution.jji.model.Result;

@JsonbPropertyOrder(value={"total", "buildTotal", "worstResult", "successRate", "latestBuild", "worstBuild", "countByResult", "deployTotal", "worstDeployResult", "deploySuccessRate", "latestDeploy", "worstDeploy", "deployCountByResult"})
public class LinkStatistics {
    private long total;
    private long buildTotal;
    private Result worstResult = Result.SUCCESS;
    private Map<Result, Long> countByResult;
    private double successRate;
    private BuildStats latestBuild;
    private BuildStats worstBuild;
    private long deployTotal;
    private Result worstDeployResult = Result.SUCCESS;
    private DeployStats latestDeploy;
    private DeployStats worstDeploy;
    private Map<Result, Long> deployCountByResult;
    private double deploySuccessRate;

    public LinkStatistics() {
        this.countByResult = new EnumMap(Arrays.stream(Result.values()).collect(Collectors.toMap(Function.identity(), result -> 0L)));
        this.deployCountByResult = new EnumMap(Arrays.stream(Result.values()).collect(Collectors.toMap(Function.identity(), result -> 0L)));
    }

    public Result getWorstResult() {
        return this.worstResult;
    }

    public LinkStatistics setWorstResult(Result worstResult) {
        this.worstResult = worstResult;
        return this;
    }

    public long getTotal() {
        return this.total;
    }

    public LinkStatistics setTotal(long total) {
        this.total = total;
        return this;
    }

    public long getBuildTotal() {
        return this.buildTotal;
    }

    public LinkStatistics setBuildTotal(long buildTotal) {
        this.buildTotal = buildTotal;
        return this;
    }

    public Map<Result, Long> getCountByResult() {
        if (this.countByResult == null) {
            this.countByResult = new EnumMap<Result, Long>(Result.class);
        }
        return this.countByResult;
    }

    public LinkStatistics setCountByResult(Map<Result, Long> countByResult) {
        this.countByResult = new EnumMap<Result, Long>(countByResult);
        this.successRate = this.calculateSuccessRate(this.getCountByResult());
        return this;
    }

    public LinkStatistics addCountByResult(Result result, long count) {
        this.getCountByResult().put(result, count);
        this.successRate = this.calculateSuccessRate(this.getCountByResult());
        return this;
    }

    public double getSuccessRate() {
        return this.successRate;
    }

    @Nullable
    public BuildStats getLatestBuild() {
        return this.latestBuild;
    }

    public LinkStatistics setLatestBuild(BuildStats latestBuild) {
        this.latestBuild = latestBuild;
        return this;
    }

    @Nullable
    public BuildStats getWorstBuild() {
        return this.worstBuild;
    }

    public LinkStatistics setWorstBuild(BuildStats worstBuild) {
        this.worstBuild = worstBuild;
        if (this.worstResult == null || worstBuild != null && worstBuild.getResult().isWorseThan(this.worstResult)) {
            this.worstResult = worstBuild.result;
        }
        return this;
    }

    public long getDeployTotal() {
        return this.deployTotal;
    }

    public LinkStatistics setDeployTotal(long deployTotal) {
        this.deployTotal = deployTotal;
        return this;
    }

    public Result getWorstDeployResult() {
        return this.worstDeployResult;
    }

    public LinkStatistics setWorstDeployResult(Result worstDeployResult) {
        this.worstDeployResult = worstDeployResult;
        return this;
    }

    public DeployStats getLatestDeploy() {
        return this.latestDeploy;
    }

    public LinkStatistics setLatestDeploy(DeployStats latestDeploy) {
        this.latestDeploy = latestDeploy;
        return this;
    }

    public DeployStats getWorstDeploy() {
        return this.worstDeploy;
    }

    public LinkStatistics setWorstDeploy(DeployStats worstDeploy) {
        this.worstDeploy = worstDeploy;
        if (this.worstDeployResult == null || worstDeploy != null && worstDeploy.getResult().isWorseThan(this.worstDeployResult)) {
            this.worstDeployResult = worstDeploy.result;
        }
        return this;
    }

    public Map<Result, Long> getDeployCountByResult() {
        if (this.deployCountByResult == null) {
            this.deployCountByResult = new EnumMap<Result, Long>(Result.class);
        }
        return this.deployCountByResult;
    }

    public LinkStatistics setDeployCountByResult(Map<Result, Long> deployCountByResult) {
        this.deployCountByResult = deployCountByResult;
        this.deploySuccessRate = this.calculateSuccessRate(this.getDeployCountByResult());
        return this;
    }

    public LinkStatistics addDeployCountByResult(Result result, long count) {
        this.getDeployCountByResult().put(result, count);
        this.deploySuccessRate = this.calculateSuccessRate(this.getDeployCountByResult());
        return this;
    }

    public double getDeploySuccessRate() {
        return this.deploySuccessRate;
    }

    private double calculateSuccessRate(Map<Result, Long> results) {
        double successCount = results.getOrDefault((Object)Result.SUCCESS, 0L).longValue();
        double totalCount = results.values().stream().mapToLong(v -> v).sum();
        if (totalCount == 0.0 || successCount == 0.0 && totalCount > 0.0) {
            return 0.0;
        }
        if (successCount == totalCount) {
            return 100.0;
        }
        return successCount / totalCount * 100.0;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.total, this.buildTotal, this.worstResult, this.countByResult, this.latestBuild, this.worstBuild, this.deployTotal, this.latestDeploy, this.worstDeploy, this.deployCountByResult});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkStatistics that = (LinkStatistics)o;
        return this.total == that.total && this.buildTotal == that.buildTotal && this.worstResult == that.worstResult && this.countByResult.equals(that.countByResult) && Objects.equals(this.latestBuild, that.latestBuild) && Objects.equals(this.worstBuild, that.worstBuild) && this.deployTotal == that.deployTotal && this.worstDeployResult == that.worstDeployResult && Objects.equals(this.latestDeploy, that.latestDeploy) && Objects.equals(this.worstDeploy, that.worstDeploy) && Objects.equals(this.deployCountByResult, that.deployCountByResult);
    }

    public String toString() {
        return new StringJoiner(", ", LinkStatistics.class.getSimpleName() + "[", "]").add("total=" + this.total).add("buildTotal=" + this.buildTotal).add("worstResult=" + (Object)((Object)this.worstResult)).add("countByResult=" + this.countByResult).add("latestBuild=" + this.latestBuild).add("worstBuild=" + this.worstBuild).add("deployTotal=" + this.deployTotal).add("worstDeployResult=" + (Object)((Object)this.worstDeployResult)).add("deployCountByResult=" + this.deployCountByResult).add("latestDeploy=" + this.latestDeploy).add("worstDeploy=" + this.worstDeploy).toString();
    }

    public static class DeployStats
    extends BuildStats {
        private String deploymentId;
        private String name;
        private DeploymentEnvironmentType type;

        @JsonbCreator
        public DeployStats(@JsonbProperty String id, @JsonbProperty long timestamp, @JsonbProperty Result result, @JsonbProperty String deploymentId, @JsonbProperty String name, @JsonbProperty DeploymentEnvironmentType type) {
            super(id, timestamp, result);
            this.deploymentId = deploymentId;
            this.name = name;
            this.type = type;
        }

        public static DeployStats forDeployment(Build build, DeploymentEnvironment deploymentEnvironment) {
            return new DeployStats(build.getId(), build.getTimestamp(), build.getResult(), deploymentEnvironment.getId(), deploymentEnvironment.getName(), deploymentEnvironment.getType());
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public String getName() {
            return this.name;
        }

        public DeploymentEnvironmentType getType() {
            return this.type;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.name, this.type});
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DeployStats that = (DeployStats)o;
            return this.deploymentId.equals(that.deploymentId) && this.name.equals(that.name) && this.type == that.type;
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", DeployStats.class.getSimpleName() + "[", "]").add("deploymentId='" + this.deploymentId + "'").add("name='" + this.name + "'").add("type=" + (Object)((Object)this.type)).add("id='" + this.id + "'").add("timestamp=" + this.timestamp).add("result=" + (Object)((Object)this.result)).toString();
        }
    }

    public static class BuildStats {
        protected String id;
        protected long timestamp;
        protected Result result;

        @JsonbCreator
        public BuildStats(@JsonbProperty String id, @JsonbProperty long timestamp, @JsonbProperty Result result) {
            this.id = id;
            this.timestamp = timestamp;
            this.result = result;
        }

        public static BuildStats forBuild(Build build) {
            return new BuildStats(build.getId(), build.getTimestamp(), build.getResult());
        }

        public String getId() {
            return this.id;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Result getResult() {
            return this.result;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.timestamp, this.result});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuildStats that = (BuildStats)o;
            return this.timestamp == that.timestamp && this.id.equals(that.id) && this.result == that.result;
        }

        public String toString() {
            return new StringJoiner(", ", BuildStats.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("timestamp=" + this.timestamp).add("result=" + (Object)((Object)this.result)).toString();
        }
    }
}

