/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model;

import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.marvelution.jji.model.Build;
import org.marvelution.jji.model.HasId;
import org.marvelution.jji.model.IssueReference;
import org.marvelution.jji.model.JobsContainer;
import org.marvelution.jji.model.OperationId;
import org.marvelution.jji.model.Site;
import org.marvelution.jji.model.Syncable;
import org.marvelution.jji.utils.JobHash;
import org.marvelution.jji.utils.SiteUrl;

@XmlRootElement
@XmlAccessorType(value=jakarta.xml.bind.annotation.XmlAccessType.FIELD)
@javax.xml.bind.annotation.XmlRootElement
@javax.xml.bind.annotation.XmlAccessorType(value=XmlAccessType.FIELD)
public class Job
implements HasId<Job>,
JobsContainer,
Syncable<Job> {
    public static final String OPERATION_PREFIX = "job-sync";
    private String id;
    private Site site;
    private String name;
    @jakarta.xml.bind.annotation.XmlTransient
    @XmlTransient
    private String parentName;
    @jakarta.xml.bind.annotation.XmlTransient
    @XmlTransient
    private String fullName;
    @jakarta.xml.bind.annotation.XmlTransient
    @XmlTransient
    private String urlName;
    @jakarta.xml.bind.annotation.XmlTransient
    @XmlTransient
    private String displayName;
    @jakarta.xml.bind.annotation.XmlTransient
    @XmlTransient
    private URI displayUrl;
    private String description;
    private int lastBuild = 0;
    private int oldestBuild = -1;
    private boolean linked = false;
    private boolean deleted = false;
    private List<Build> builds;
    private List<Job> jobs;
    private Set<IssueReference> issueReferences;
    private Map<String, URI> links;

    @Override
    public Job copy() {
        Job job = new Job();
        job.id = this.id;
        if (this.site != null) {
            job.site = this.site.copy();
        }
        job.parentName = this.parentName;
        job.name = this.name;
        job.fullName = this.fullName;
        job.urlName = this.urlName;
        job.displayName = this.displayName;
        job.description = this.description;
        job.lastBuild = this.lastBuild;
        job.oldestBuild = this.oldestBuild;
        job.linked = this.linked;
        job.deleted = this.deleted;
        return job;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Job setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public Site getSite() {
        return this.site;
    }

    public Job setSite(Site site) {
        this.site = site;
        return this;
    }

    @Override
    public List<Job> getJobs() {
        if (this.jobs == null) {
            this.jobs = new ArrayList<Job>();
        }
        return this.jobs;
    }

    public Job setJobs(@Nullable List<Job> jobs) {
        this.jobs = jobs;
        return this;
    }

    @Override
    public void addJob(@Nullable Job job) {
        if (job != null) {
            this.getJobs().add(job);
        }
    }

    @Override
    public boolean shouldJobBeLinked(Job job) {
        return this.site != null && this.site.shouldJobBeLinked(job);
    }

    public String getName() {
        return this.name;
    }

    public Job setName(String name) {
        this.name = name;
        return this;
    }

    @jakarta.xml.bind.annotation.XmlElement
    @XmlElement
    @Nullable
    public String getParentName() {
        return this.determineParentName().orElse(null);
    }

    public Job setParentName(String parentName) {
        this.parentName = Objects.equals(this.name, parentName) ? null : (String)StringUtils.defaultIfBlank((CharSequence)parentName, null);
        return this;
    }

    private Optional<String> determineParentName() {
        if (StringUtils.isBlank((CharSequence)this.parentName)) {
            Job.determineParentNameFromUrlName(this.urlName).ifPresent(this::setParentName);
        }
        return Optional.ofNullable(this.parentName);
    }

    @jakarta.xml.bind.annotation.XmlElement
    @XmlElement
    public String getFullName() {
        return this.determineFullName().orElseGet(this::getName);
    }

    public Job setFullName(@Nullable String fullName) {
        this.fullName = (String)StringUtils.defaultIfBlank((CharSequence)fullName, null);
        return this;
    }

    private Optional<String> determineFullName() {
        if (StringUtils.isBlank((CharSequence)this.fullName)) {
            this.determineParentName().filter(name -> !Objects.equals(name, this.getName())).map(parent -> parent + "/" + this.getName()).ifPresent(this::setFullName);
        }
        return Optional.ofNullable(this.fullName);
    }

    @jakarta.xml.bind.annotation.XmlElement
    @XmlElement
    public String getUrlName() {
        return this.urlName != null ? this.urlName : this.name;
    }

    public Job setUrlName(@Nullable String urlName) {
        this.urlName = (String)StringUtils.defaultIfBlank((CharSequence)urlName, null);
        return this;
    }

    @Nullable
    public String getUrlNameOrNull() {
        if (StringUtils.isNotBlank((CharSequence)this.urlName)) {
            return this.urlName;
        }
        return null;
    }

    @Override
    @jakarta.xml.bind.annotation.XmlElement
    @XmlElement
    public String getDisplayName() {
        return this.determineDisplayName().orElseGet(this::getName);
    }

    @Override
    public OperationId getOperationId() {
        return OperationId.of(OPERATION_PREFIX, this.id);
    }

    @Override
    public boolean isEnabled() {
        return (this.site == null || this.site.isEnabled()) && this.isLinked() && !this.isDeleted();
    }

    public Job setDisplayName(@Nullable String displayName) {
        this.displayName = Objects.equals(this.name, displayName) ? null : (String)StringUtils.defaultIfBlank((CharSequence)displayName, null);
        return this;
    }

    @Nullable
    public String getDisplayNameOrNull() {
        return this.determineDisplayName().orElse(null);
    }

    private Optional<String> determineDisplayName() {
        if (StringUtils.isBlank((CharSequence)this.displayName)) {
            Optional.ofNullable(this.getFullName()).filter(name -> !Objects.equals(name, this.getName())).map(name -> name.replace("/", " - ")).ifPresent(this::setDisplayName);
        }
        return Optional.ofNullable(this.displayName);
    }

    @jakarta.xml.bind.annotation.XmlElement
    @XmlElement
    public URI getDisplayUrl() {
        if (this.displayUrl == null) {
            this.displayUrl = SiteUrl.displayUrl().job(this).nullable().url();
        }
        return this.displayUrl;
    }

    public Job setDisplayUrl(@Nullable URI displayUrl) {
        this.displayUrl = displayUrl;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Job setDescription(@Nullable String description) {
        this.description = (String)StringUtils.defaultIfBlank((CharSequence)description, null);
        return this;
    }

    public int getLastBuild() {
        return this.lastBuild;
    }

    public Job setLastBuild(int lastBuild) {
        this.lastBuild = lastBuild;
        return this;
    }

    public Optional<Build> getLastBuildObject() {
        return this.locateBuild(this.lastBuild);
    }

    public int getOldestBuild() {
        return this.oldestBuild;
    }

    public Job setOldestBuild(int oldestBuild) {
        this.oldestBuild = oldestBuild;
        return this;
    }

    public Optional<Build> getOldestBuildObject() {
        return this.locateBuild(this.oldestBuild);
    }

    private Optional<Build> locateBuild(int number) {
        return this.getBuilds().stream().filter(build -> build.getNumber() == number).findFirst();
    }

    public boolean isLinked() {
        return this.linked;
    }

    public Job setLinked(boolean linked) {
        this.linked = linked;
        return this;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public Job setDeleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    public boolean hasBuilds() {
        return !this.getBuilds().isEmpty() || this.lastBuild > 0 || this.oldestBuild > 0;
    }

    public List<Build> getBuilds() {
        if (this.builds == null) {
            this.builds = new ArrayList<Build>();
        }
        return this.builds;
    }

    public Job setBuilds(@Nullable List<Build> builds) {
        this.builds = Optional.ofNullable(builds).map(ArrayList::new).orElse(null);
        return this;
    }

    public Job addBuild(@Nullable Build build) {
        if (build != null) {
            this.getBuilds().add(build);
        }
        return this;
    }

    public Set<IssueReference> getIssueReferences() {
        if (this.issueReferences == null) {
            this.issueReferences = new HashSet<IssueReference>();
        }
        return this.issueReferences;
    }

    public Job setIssueReferences(Collection<IssueReference> issueReferences) {
        this.issueReferences = issueReferences != null ? new HashSet<IssueReference>(issueReferences) : new HashSet<IssueReference>();
        return this;
    }

    public Map<String, URI> getLinks() {
        if (this.links == null) {
            this.links = new HashMap<String, URI>();
        }
        return this.links;
    }

    public Job setLinks(Map<String, URI> links) {
        this.links = links;
        return this;
    }

    public Job addLink(String name, URI link) {
        this.getLinks().put(name, link);
        return this;
    }

    public boolean shouldBeLinked() {
        return this.shouldJobBeLinked(this);
    }

    public String getHash() {
        return JobHash.hash(this);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.site, this.getUrlName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        return Objects.equals(this.id, job.id) && Objects.equals(this.site, job.site) && Objects.equals(this.getUrlName(), job.getUrlName());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).append("siteId", this.site != null ? this.site.getId() : null).append("name", (Object)this.name).append("urlName", (Object)this.urlName).append("lastBuild", this.lastBuild).append("linked", this.linked).append("deleted", this.deleted).toString();
    }

    public static Optional<String> determineParentNameFromUrlName(String urlName) {
        return Optional.ofNullable(urlName).map(url -> url.replace("/job/", "/")).map(url -> url.replace("/branch/", "/")).filter(name -> name.contains("/")).map(name -> name.substring(0, name.lastIndexOf("/"))).map(url -> {
            try {
                return URLDecoder.decode(url, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

