/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model;

import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.net.URI;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlRootElement;
import org.marvelution.jji.model.adapters.javax.URIAdapter;

@jakarta.xml.bind.annotation.XmlRootElement
@XmlAccessorType(value=jakarta.xml.bind.annotation.XmlAccessType.FIELD)
@XmlRootElement
@javax.xml.bind.annotation.XmlAccessorType(value=XmlAccessType.FIELD)
public class IssueReference {
    private String projectKey;
    private String issueKey;
    @XmlJavaTypeAdapter(value=org.marvelution.jji.model.adapters.URIAdapter.class)
    @javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter(value=URIAdapter.class)
    private URI issueUrl;
    private Set<Field> fields;

    public String getProjectKey() {
        return this.projectKey;
    }

    public IssueReference setProjectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public IssueReference setIssueKey(String issueKey) {
        this.issueKey = issueKey;
        return this;
    }

    public URI getIssueUrl() {
        return this.issueUrl;
    }

    public IssueReference setIssueUrl(URI issueUrl) {
        this.issueUrl = issueUrl;
        return this;
    }

    public Set<Field> getFields() {
        if (this.fields == null) {
            this.fields = new HashSet<Field>();
        }
        return this.fields;
    }

    public IssueReference setFields(Set<Field> fields) {
        this.fields = new HashSet<Field>(fields);
        return this;
    }

    public IssueReference addField(String key, String name, String value) {
        this.getFields().add(new Field().setKey(key).setName(name).setValue(value));
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.projectKey, this.issueKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueReference that = (IssueReference)o;
        return Objects.equals(this.projectKey, that.projectKey) && Objects.equals(this.issueKey, that.issueKey);
    }

    public String toString() {
        return new StringJoiner(", ", IssueReference.class.getSimpleName() + "[", "]").add("projectKey='" + this.projectKey + "'").add("issueKey='" + this.issueKey + "'").toString();
    }

    @jakarta.xml.bind.annotation.XmlRootElement
    @XmlAccessorType(value=jakarta.xml.bind.annotation.XmlAccessType.FIELD)
    public static class Field {
        private String key;
        private String name;
        private String value;

        public String getKey() {
            return this.key;
        }

        public Field setKey(String key) {
            this.key = key;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Field setName(String name) {
            this.name = name;
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public Field setValue(String value) {
            this.value = value;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            Field field = (Field)o;
            return Objects.equals(this.key, field.key) && Objects.equals(this.name, field.name) && Objects.equals(this.value, field.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.name, this.value);
        }

        public String toString() {
            return new StringJoiner(", ", Field.class.getSimpleName() + "[", "]").add("key='" + this.key + "'").add("name='" + this.name + "'").add("value='" + this.value + "'").toString();
        }
    }
}

