/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IssueLinksUpdatedEvent {
    private final String buildId;
    private final Set<String> issueKeys;

    public IssueLinksUpdatedEvent(String buildId, String ... issueKeys) {
        this(buildId, Stream.of(issueKeys).collect(Collectors.toSet()));
    }

    @JsonCreator
    public IssueLinksUpdatedEvent(@JsonProperty(value="buildId") String buildId, @JsonProperty(value="issueKeys") Set<String> issueKeys) {
        this.buildId = buildId;
        this.issueKeys = issueKeys;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public Set<String> getIssueKeys() {
        return this.issueKeys;
    }

    public int hashCode() {
        return Objects.hash(this.buildId, this.issueKeys);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueLinksUpdatedEvent that = (IssueLinksUpdatedEvent)o;
        return Objects.equals(this.buildId, that.buildId) && this.issueKeys.equals(that.issueKeys);
    }

    public String toString() {
        return new StringJoiner(", ", IssueLinksUpdatedEvent.class.getSimpleName() + "[", "]").add("buildId='" + this.buildId + "'").add("issueKeys=" + this.issueKeys).toString();
    }
}

