/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.events;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDateTime;
import java.util.Objects;
import org.marvelution.jji.model.Syncable;

public abstract class AbstractSynchronizedEvent<S extends Syncable<S>> {
    private S syncable;
    private LocalDateTime timestamp;

    AbstractSynchronizedEvent(S syncable) {
        this(syncable, LocalDateTime.now());
    }

    AbstractSynchronizedEvent(S syncable, LocalDateTime timestamp) {
        this.syncable = (Syncable)syncable.copy();
        this.timestamp = timestamp;
    }

    @JsonIgnore
    public S getSyncable() {
        return this.syncable;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return Objects.hash(this.syncable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractSynchronizedEvent)) {
            return false;
        }
        AbstractSynchronizedEvent that = (AbstractSynchronizedEvent)o;
        return this.syncable.equals(that.syncable);
    }
}

