/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.net;

import com.ngrok.Connection;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ConnectionInputStream
extends InputStream {
    private final Connection connection;
    private final ByteBuffer buffer;

    public ConnectionInputStream(Connection connection, int bufferSize) {
        this.connection = connection;
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
        this.buffer.flip();
    }

    private void prepare() throws IOException {
        if (this.buffer.hasRemaining()) {
            return;
        }
        this.buffer.clear();
        this.connection.read(this.buffer);
    }

    @Override
    public int read() throws IOException {
        this.prepare();
        return this.buffer.get();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.prepare();
        int readLen = Math.min(len, this.buffer.remaining());
        this.buffer.get(b, off, readLen);
        return readLen;
    }
}

