/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok;

import com.ngrok.EdgeBuilder;
import com.ngrok.Forwarder;
import com.ngrok.HttpBuilder;
import com.ngrok.Listener;
import com.ngrok.TcpBuilder;
import com.ngrok.TlsBuilder;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface Session
extends AutoCloseable {
    public static Builder withAuthtoken(String authtoken) {
        return new Builder(authtoken);
    }

    public static Builder withAuthtokenFromEnv() {
        return new Builder(System.getenv("NGROK_AUTHTOKEN"));
    }

    public static Session connect(Builder builder) throws IOException {
        try {
            Class<?> clazz = Class.forName("com.ngrok.NativeSession");
            Method method = clazz.getMethod("connect", Builder.class);
            return (Session)method.invoke(null, builder);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getId();

    public String getMetadata();

    default public TcpBuilder tcpEndpoint() {
        return new TcpBuilder(this);
    }

    public Listener.Endpoint listenTcp(TcpBuilder var1) throws IOException;

    public Forwarder.Endpoint forwardTcp(TcpBuilder var1, URL var2) throws IOException;

    default public TlsBuilder tlsEndpoint() {
        return new TlsBuilder(this);
    }

    public Listener.Endpoint listenTls(TlsBuilder var1) throws IOException;

    public Forwarder.Endpoint forwardTls(TlsBuilder var1, URL var2) throws IOException;

    default public HttpBuilder httpEndpoint() {
        return new HttpBuilder(this);
    }

    public Listener.Endpoint listenHttp(HttpBuilder var1) throws IOException;

    public Forwarder.Endpoint forwardHttp(HttpBuilder var1, URL var2) throws IOException;

    default public EdgeBuilder edge() {
        return new EdgeBuilder(this);
    }

    public Listener.Edge listenEdge(EdgeBuilder var1) throws IOException;

    public Forwarder.Edge forwardEdge(EdgeBuilder var1, URL var2) throws IOException;

    public void closeListener(String var1) throws IOException;

    public void closeForwarder(String var1) throws IOException;

    @Override
    public void close() throws IOException;

    public static class Builder {
        private final String authtoken;
        private Optional<Duration> heartbeatInterval = Optional.empty();
        private Optional<Duration> heartbeatTolerance = Optional.empty();
        private Optional<String> metadata = Optional.empty();
        private Optional<String> serverAddr = Optional.empty();
        private byte[] caCert;
        private CommandHandler stopCallback;
        private CommandHandler restartCallback;
        private CommandHandler updateCallback;
        private HeartbeatHandler heartbeatHandler;
        private final List<ClientInfo> clientInfos = new ArrayList<ClientInfo>();

        private Builder(String authtoken) {
            this.authtoken = Objects.requireNonNullElse(authtoken, "");
        }

        public Builder heartbeatInterval(Duration duration) {
            this.heartbeatInterval = Optional.of(duration);
            return this;
        }

        public Builder heartbeatTolerance(Duration duration) {
            this.heartbeatTolerance = Optional.of(duration);
            return this;
        }

        public Builder metadata(String metadata) {
            this.metadata = Optional.of(metadata);
            return this;
        }

        public Builder serverAddr(String addr) {
            this.serverAddr = Optional.of(addr);
            return this;
        }

        public Builder caCert(byte[] data) {
            this.caCert = data;
            return this;
        }

        public Builder stopCallback(CommandHandler callback) {
            this.stopCallback = callback;
            return this;
        }

        public Builder restartCallback(CommandHandler callback) {
            this.restartCallback = callback;
            return this;
        }

        public Builder updateCallback(CommandHandler callback) {
            this.updateCallback = callback;
            return this;
        }

        public Builder heartbeatHandler(HeartbeatHandler heartbeatHandler) {
            this.heartbeatHandler = heartbeatHandler;
            return this;
        }

        public Builder addClientInfo(String name, String version) {
            this.clientInfos.add(new ClientInfo(name, version, null));
            return this;
        }

        public Builder addClientInfo(String name, String version, String comments) {
            this.clientInfos.add(new ClientInfo(name, version, comments));
            return this;
        }

        public String getAuthtoken() {
            return this.authtoken;
        }

        public Optional<Duration> getHeartbeatInterval() {
            return this.heartbeatInterval;
        }

        public Optional<Duration> getHeartbeatTolerance() {
            return this.heartbeatTolerance;
        }

        public Optional<String> getMetadata() {
            return this.metadata;
        }

        public Optional<String> getServerAddr() {
            return this.serverAddr;
        }

        public byte[] getCaCert() {
            return this.caCert;
        }

        public CommandHandler stopCallback() {
            return this.stopCallback;
        }

        public CommandHandler restartCallback() {
            return this.restartCallback;
        }

        public CommandHandler updateCallback() {
            return this.updateCallback;
        }

        public HeartbeatHandler heartbeatHandler() {
            return this.heartbeatHandler;
        }

        public List<ClientInfo> getClientInfos() {
            return this.clientInfos;
        }

        public Session connect() throws IOException {
            return Session.connect(this);
        }
    }

    public static class ClientInfo {
        private final String type;
        private final String version;
        private final Optional<String> comments;

        public ClientInfo(String type, String version, String comments) {
            this.type = Objects.requireNonNull(type);
            this.version = Objects.requireNonNull(version);
            this.comments = Optional.ofNullable(comments);
        }

        public String getType() {
            return this.type;
        }

        public String getVersion() {
            return this.version;
        }

        public Optional<String> getComments() {
            return this.comments;
        }
    }

    public static interface HeartbeatHandler {
        public void heartbeat(long var1);

        default public void timeout() {
        }
    }

    public static interface CommandHandler {
        public void onCommand();
    }
}

