/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok;

import com.ngrok.EndpointBuilder;
import com.ngrok.Forwarder;
import com.ngrok.Http;
import com.ngrok.Listener;
import com.ngrok.Session;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HttpBuilder
extends EndpointBuilder<HttpBuilder>
implements Listener.Builder<Listener.Endpoint>,
Forwarder.Builder<Forwarder.Endpoint> {
    private final Session session;
    private Http.Scheme scheme;
    private Optional<String> domain = Optional.empty();
    private byte[] mutualTLSCA;
    private boolean compression = false;
    private boolean websocketTcpConversion = false;
    private Optional<Double> circuitBreaker = Optional.empty();
    private final List<Http.Header> requestHeaders = new ArrayList<Http.Header>();
    private final List<Http.Header> responseHeaders = new ArrayList<Http.Header>();
    private final List<String> removeRequestHeaders = new ArrayList<String>();
    private final List<String> removeResponseHeaders = new ArrayList<String>();
    private Http.BasicAuth basicAuthOptions;
    private Http.OAuth oauthOptions;
    private Http.OIDC oidcOptions;
    private Http.WebhookVerification webhookVerification;

    public HttpBuilder(Session session) {
        this.session = session;
    }

    public HttpBuilder scheme(Http.Scheme scheme) {
        this.scheme = Objects.requireNonNull(scheme);
        return this;
    }

    public HttpBuilder domain(String domain) {
        this.domain = Optional.of(domain);
        return this;
    }

    public HttpBuilder mutualTLSCA(byte[] mutualTLSCA) {
        this.mutualTLSCA = Objects.requireNonNull(mutualTLSCA);
        return this;
    }

    public HttpBuilder compression() {
        this.compression = true;
        return this;
    }

    public HttpBuilder websocketTcpConversion() {
        this.websocketTcpConversion = true;
        return this;
    }

    public HttpBuilder circuitBreaker(double value) {
        this.circuitBreaker = Optional.of(value);
        return this;
    }

    public HttpBuilder addRequestHeader(String name, String value) {
        this.requestHeaders.add(new Http.Header(name, value));
        return this;
    }

    public HttpBuilder addResponseHeader(String name, String value) {
        this.responseHeaders.add(new Http.Header(name, value));
        return this;
    }

    public HttpBuilder removeRequestHeader(String name) {
        this.removeRequestHeaders.add(Objects.requireNonNull(name));
        return this;
    }

    public HttpBuilder removeResponseHeader(String name) {
        this.removeResponseHeaders.add(Objects.requireNonNull(name));
        return this;
    }

    public HttpBuilder basicAuthOptions(Http.BasicAuth options) {
        this.basicAuthOptions = options;
        return this;
    }

    public HttpBuilder oauthOptions(Http.OAuth options) {
        this.oauthOptions = options;
        return this;
    }

    public HttpBuilder oidcOptions(Http.OIDC options) {
        this.oidcOptions = options;
        return this;
    }

    public HttpBuilder webhookVerification(Http.WebhookVerification webhookVerification) {
        this.webhookVerification = webhookVerification;
        return this;
    }

    public Http.Scheme getScheme() {
        return this.scheme;
    }

    public Optional<String> getSchemeName() {
        return Optional.ofNullable(this.scheme).map(s -> s.name);
    }

    public Optional<String> getDomain() {
        return this.domain;
    }

    public byte[] getMutualTLSCA() {
        return this.mutualTLSCA;
    }

    public boolean isCompression() {
        return this.compression;
    }

    public boolean isWebsocketTcpConversion() {
        return this.websocketTcpConversion;
    }

    public Optional<Double> getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public List<Http.Header> getRequestHeaders() {
        return this.requestHeaders;
    }

    public List<Http.Header> getResponseHeaders() {
        return this.responseHeaders;
    }

    public List<String> getRemoveRequestHeaders() {
        return this.removeRequestHeaders;
    }

    public List<String> getRemoveResponseHeaders() {
        return this.removeResponseHeaders;
    }

    public Http.BasicAuth getBasicAuth() {
        return this.basicAuthOptions;
    }

    public Http.OAuth getOauth() {
        return this.oauthOptions;
    }

    public Http.OIDC getOidc() {
        return this.oidcOptions;
    }

    public Http.WebhookVerification getWebhookVerification() {
        return this.webhookVerification;
    }

    @Override
    public Listener.Endpoint listen() throws IOException {
        return this.session.listenHttp(this);
    }

    @Override
    public Forwarder.Endpoint forward(URL url) throws IOException {
        return this.session.forwardHttp(this, url);
    }
}

