/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public interface Http {

    public static class WebhookVerification {
        private final String provider;
        private final String secret;

        public WebhookVerification(String provider, String secret) {
            this.provider = Objects.requireNonNull(provider);
            this.secret = Objects.requireNonNull(secret);
        }

        public String getProvider() {
            return this.provider;
        }

        public String getSecret() {
            return this.secret;
        }
    }

    public static class OIDC {
        private final String issuerUrl;
        private final String clientId;
        private final String clientSecret;
        private final List<String> allowEmails = new ArrayList<String>();
        private final List<String> allowDomains = new ArrayList<String>();
        private final List<String> scopes = new ArrayList<String>();

        public OIDC(String issuerUrl, String clientId, String clientSecret) {
            this.issuerUrl = Objects.requireNonNull(issuerUrl);
            this.clientId = Objects.requireNonNull(clientId);
            this.clientSecret = Objects.requireNonNull(clientSecret);
        }

        public OIDC allowEmail(String email) {
            this.allowEmails.add(Objects.requireNonNull(email));
            return this;
        }

        public OIDC allowDomain(String domain) {
            this.allowDomains.add(Objects.requireNonNull(domain));
            return this;
        }

        public OIDC scope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope));
            return this;
        }

        public String getIssuerUrl() {
            return this.issuerUrl;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public List<String> getAllowEmail() {
            return this.allowEmails;
        }

        public List<String> getAllowDomain() {
            return this.allowDomains;
        }

        public List<String> getScope() {
            return this.scopes;
        }
    }

    public static class OAuth {
        private final String provider;
        private String clientId;
        private String clientSecret;
        private final List<String> allowEmails = new ArrayList<String>();
        private final List<String> allowDomains = new ArrayList<String>();
        private final List<String> scopes = new ArrayList<String>();

        public OAuth(String provider) {
            this.provider = Objects.requireNonNull(provider);
        }

        public OAuth client(String id, String secret) {
            this.clientId = Objects.requireNonNull(id);
            this.clientSecret = Objects.requireNonNull(secret);
            return this;
        }

        public OAuth allowEmail(String email) {
            this.allowEmails.add(Objects.requireNonNull(email));
            return this;
        }

        public OAuth allowDomain(String domain) {
            this.allowDomains.add(Objects.requireNonNull(domain));
            return this;
        }

        public OAuth scope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope));
            return this;
        }

        public String getProvider() {
            return this.provider;
        }

        public boolean hasClientConfigured() {
            return this.clientId != null && this.clientSecret != null;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public List<String> getAllowEmails() {
            return this.allowEmails;
        }

        public List<String> getAllowDomains() {
            return this.allowDomains;
        }

        public List<String> getScopes() {
            return this.scopes;
        }
    }

    public static class BasicAuth {
        private final String username;
        private final String password;

        public BasicAuth(String username, String password) {
            this.username = Objects.requireNonNull(username);
            this.password = Objects.requireNonNull(password);
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }

    public static class Header {
        private final String name;
        private final String value;

        public Header(String name, String value) {
            this.name = Objects.requireNonNull(name);
            this.value = Objects.requireNonNull(value);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Scheme {
        HTTP("HTTP"),
        HTTPS("HTTPS");

        public final String name;

        private Scheme(String name) {
            this.name = name;
        }
    }
}

