/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.tunnel;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.marvelution.jji.tunnel.TunnelManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.filter.OncePerRequestFilter;

public class TunnelAuthenticationFilter
extends OncePerRequestFilter {
    private final TunnelManager tunnelManager;

    public TunnelAuthenticationFilter(TunnelManager tunnelManager) {
        this.tunnelManager = tunnelManager;
    }

    protected String getFilterName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String tunnelId = request.getHeader("X-Tunnel-Id");
        if (tunnelId != null) {
            String tunnelToken = request.getHeader("X-Tunnel-Token");
            try {
                this.tunnelManager.verifyTunnelToken(tunnelId, tunnelToken);
            }
            catch (AccessDeniedException e) {
                response.sendError(401, e.getMessage());
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

