/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.tunnel;

import com.ngrok.Forwarder;
import com.ngrok.Http;
import com.ngrok.HttpBuilder;
import com.ngrok.Session;
import jakarta.json.Json;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.marvelution.jji.JiraIntegrationPlugin;
import org.marvelution.jji.configuration.JiraSite;
import org.marvelution.jji.tunnel.TunnelDetails;
import org.marvelution.jji.tunnel.TunnelManager;
import org.springframework.security.access.AccessDeniedException;

public class NgrokConnector {
    public static final String X_TUNNEL_ID = "X-Tunnel-Id";
    public static final String X_TUNNEL_TOKEN = "X-Tunnel-Token";
    private static final Logger LOGGER = Logger.getLogger(NgrokConnector.class.getName());
    private final TunnelManager tunnelManager;
    private final JiraSite site;
    private final TunnelDetails details;
    private Thread runner;
    private Throwable connectException;
    private Session session;
    private Forwarder.Endpoint endpoint;

    public NgrokConnector(TunnelManager tunnelManager, JiraSite site, TunnelDetails details) {
        this.tunnelManager = tunnelManager;
        this.site = site;
        this.details = details;
    }

    public void verifyTunnelToken(String tunnelId, String tunnelToken) {
        if (this.site.getIdentifier().equals(tunnelId) && !this.details.token.equals(tunnelToken)) {
            throw new AccessDeniedException("missing or invalid tunnel token");
        }
    }

    public void connect() {
        if (this.runner == null) {
            this.runner = new Thread(this::doConnect);
            this.runner.start();
        }
    }

    private void doConnect() {
        LOGGER.info("Connecting tunnel for " + String.valueOf(this.site));
        String metadata = Json.createObjectBuilder().add("site", this.site.getIdentifier()).build().toString();
        String forwardTo = this.tunnelManager.getForwardTo();
        try {
            this.session = this.sessionConnect(Session.withAuthtoken((String)this.details.authtoken).metadata(metadata).addClientInfo("Jenkins", Jenkins.VERSION).addClientInfo("jira-integration", JiraIntegrationPlugin.getVersion()).serverAddr(this.details.serverAddr).stopCallback(() -> {
                LOGGER.info(String.format("Stop callback received for tunnel %s", this.details.domain));
                this.tunnelManager.disconnectTunnelForSite(this.site);
            }).restartCallback(() -> {
                LOGGER.info(String.format("Restart callback received for tunnel%s", this.details.domain));
                this.reconnect();
            }).updateCallback(() -> {
                LOGGER.info(String.format("Update callback received for tunnel %s", this.details.domain));
                this.reconnect();
            }).heartbeatHandler(latency -> LOGGER.fine(String.format("Tunnel %s heartbeat %d ms", this.details.domain, latency))));
            this.endpoint = ((HttpBuilder)((HttpBuilder)this.session.httpEndpoint().scheme(Http.Scheme.HTTPS).addRequestHeader(X_TUNNEL_ID, this.site.getIdentifier()).metadata(metadata)).forwardsTo(forwardTo)).forward(URI.create(forwardTo).toURL());
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Failed to setup the tunnel session", e);
            this.connectException = e;
        }
    }

    private Session sessionConnect(Session.Builder builder) throws IOException {
        try {
            Class<?> clazz = this.tunnelManager.getTunnelClassLoader().loadClass("com.ngrok.NativeSession");
            Method method = clazz.getMethod("connect", Session.Builder.class);
            return (Session)method.invoke(null, builder);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void disconnect() {
        if (this.runner != null) {
            LOGGER.info("Disconnecting tunnel for " + String.valueOf(this.site));
            try {
                this.session.closeForwarder(this.endpoint.getId());
                this.session.close();
                this.connectException = null;
                this.runner = null;
                this.endpoint = null;
                this.session = null;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to stop tunnel session", e);
            }
        }
    }

    public void reconnect() {
        LOGGER.info("Reconnecting tunnel for " + String.valueOf(this.site));
        this.disconnect();
        this.connect();
    }

    public void close() {
        this.disconnect();
    }

    @Nullable
    public Throwable getConnectException() {
        return this.connectException;
    }
}

