/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.configuration;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.util.HttpResponses;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.marvelution.jji.Messages;
import org.marvelution.jji.configuration.JiraSite;
import org.marvelution.jji.configuration.JiraSitesConfiguration;

@Extension
@Symbol(value={"jiraSites"})
public class JiraSitesMonitor
extends AdministrativeMonitor {
    private JiraSitesConfiguration sitesConfiguration;

    @Inject
    public void setSitesConfiguration(JiraSitesConfiguration sitesConfiguration) {
        this.sitesConfiguration = sitesConfiguration;
    }

    public boolean isActivated() {
        return !this.getSites().isEmpty();
    }

    public List<JiraSite> getSites() {
        return this.sitesConfiguration.getSites().stream().filter(site -> !site.isEnabled() || !site.isUpToDate()).collect(Collectors.toList());
    }

    public String describe(JiraSite site) {
        if (!site.isUpToDate()) {
            return Messages.site_not_up_to_date();
        }
        if (!site.isEnabled()) {
            if (site.getLastStatus() == -1) {
                return Messages.site_check_failed();
            }
            if (site.getLastStatus() == 402) {
                return Messages.site_license_issue();
            }
            return Messages.site_status_unknown();
        }
        return Messages.site_up_and_ready();
    }

    @RequirePOST
    public HttpResponse doForward() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        return HttpResponses.redirectViaContextPath((String)"/manage/jji");
    }
}

