/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.configuration;

import com.atlassian.connect.spring.internal.jwt.CanonicalHttpRequest;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameSpecification;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import com.cloudbees.plugins.credentials.domains.SchemeSpecification;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.security.ACL;
import hudson.util.Secret;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.marvelution.jji.JiraUtils;
import org.marvelution.jji.events.JobNotificationType;
import org.marvelution.jji.model.parsers.ParserProvider;
import org.marvelution.jji.synctoken.CanonicalHttpServletRequest;
import org.marvelution.jji.synctoken.SyncTokenBuilder;

public class JiraSite
extends AbstractDescribableImpl<JiraSite>
implements Serializable {
    public static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final long serialVersionUID = 1L;
    private URI uri;
    private String identifier;
    private String sharedSecret;
    private String sharedSecretId;
    private String name;
    private String contextJson;
    private transient JSONObject context;
    private boolean postJson;
    private boolean tunneled;
    private int lastStatus = 200;
    private boolean upToDate = true;

    @DataBoundConstructor
    public JiraSite(URI uri) {
        this.uri = uri;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @DataBoundSetter
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public JiraSite withIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    @DataBoundSetter
    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public JiraSite withSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
        return this;
    }

    public String getSharedSecretId() {
        return this.sharedSecretId;
    }

    @DataBoundSetter
    public JiraSite setSharedSecretId(String sharedSecretId) {
        this.sharedSecretId = sharedSecretId;
        return this;
    }

    public String getName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.name, (CharSequence)"Jira");
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public JiraSite withName(String name) {
        this.name = name;
        return this;
    }

    public String getContextJson() {
        if (this.context != null) {
            return this.context.toString();
        }
        return Objects.requireNonNullElse(this.contextJson, "{}");
    }

    @DataBoundSetter
    public void setContextJson(String contextJson) {
        this.contextJson = contextJson;
        this.context = JSONObject.fromObject((Object)contextJson);
    }

    public JSONObject getContext() {
        return this.context;
    }

    public void setContext(JSONObject context) {
        this.context = context;
        this.contextJson = this.getContextJson();
    }

    public JiraSite withContext(JSONObject context) {
        this.setContext(context);
        return this;
    }

    public boolean isPostJson() {
        return this.postJson;
    }

    @DataBoundSetter
    public void setPostJson(boolean postJson) {
        this.postJson = postJson;
    }

    public JiraSite withPostJson(boolean postJson) {
        this.postJson = postJson;
        return this;
    }

    public boolean isTunneled() {
        return this.tunneled;
    }

    @DataBoundSetter
    public void setTunneled(boolean tunneled) {
        this.tunneled = tunneled;
    }

    public JiraSite withTunneled(boolean tunneled) {
        this.tunneled = tunneled;
        return this;
    }

    public boolean isEnabled() {
        int family = this.lastStatus / 100;
        return family == 2 || family == 3;
    }

    public int getLastStatus() {
        return this.lastStatus;
    }

    @DataBoundSetter
    public void setLastStatus(int lastStatus) {
        this.lastStatus = lastStatus;
    }

    public boolean isUpToDate() {
        return this.upToDate;
    }

    @DataBoundSetter
    public void setUpToDate(boolean upToDate) {
        this.upToDate = upToDate;
    }

    public Request createGetBaseUrlRequest() {
        return this.signRequest(new Request.Builder().get().url(this.getHttpUrl("base-url")).build());
    }

    public Request createGetIssueLinksRequest(String jobHash, int buildNumber) {
        return this.signRequest(new Request.Builder().get().url(this.getHttpUrl("integration/" + jobHash + "/" + buildNumber + "/links")).build());
    }

    public Request createRegisterRequest() {
        return this.signRequest(new Request.Builder().post(RequestBody.create((String)"", (MediaType)JSON)).url(this.getHttpUrl("integration/register/" + this.identifier)).addHeader("Content-Length", "0").build());
    }

    public Request createGetRegisterDetailsRequest() {
        return this.signRequest(new Request.Builder().get().url(this.getHttpUrl("integration/register/" + this.identifier)).build());
    }

    public Request createUnregisterRequest() {
        return this.signRequest(new Request.Builder().delete().url(this.getHttpUrl("integration/register/" + this.identifier)).build());
    }

    public Request createNotifyJobCreatedRequest(Item item) {
        return this.signRequest(new Request.Builder().url(this.getHttpUrl("integration/" + JiraUtils.getJobHash(item))).header("X-Notification-type", JobNotificationType.JOB_CREATED.value()).post(RequestBody.create((String)JiraUtils.asJson(item, Arrays.asList("name", "url")), (MediaType)JSON)).build());
    }

    public Request createNotifyJobRequest(Item item, JobNotificationType notificationType) {
        return this.signRequest(new Request.Builder().url(this.getHttpUrl("integration/" + JiraUtils.getJobHash(item))).header("X-Notification-type", notificationType.value()).post(RequestBody.create((String)JiraUtils.asJson(item, ParserProvider.jobParser().fields()), (MediaType)JSON)).build());
    }

    public Request createNotifyJobMovedRequest(String oldJobHash, Item newItem) {
        return this.signRequest(new Request.Builder().post(RequestBody.create((String)JiraUtils.asJson(newItem, ParserProvider.jobParser().fields()), (MediaType)JSON)).header("X-Notification-type", JobNotificationType.JOB_MOVED.value()).url(this.getHttpUrl("integration/" + oldJobHash)).build());
    }

    public Request createNotifyBuildCompleted(Run run) {
        Request.Builder request = this.isPostJson() ? new Request.Builder().post(RequestBody.create((String)JiraUtils.asJson(run, ParserProvider.buildParser().fields()), (MediaType)JSON)) : new Request.Builder().put(RequestBody.create((String)JiraUtils.getAllParentHashes(run).stream().collect(Collectors.joining("\",\"", "[\"", "\"]")), (MediaType)JSON));
        return this.signRequest(request.url(this.getHttpUrl("integration/" + JiraUtils.getJobHash(run) + "/" + run.getNumber())).build());
    }

    public Request createNotifyJobDeletedRequest(Item item) {
        return this.signRequest(new Request.Builder().delete().url(this.getHttpUrl("integration/" + JiraUtils.getJobHash(item))).build());
    }

    public Request createNotifyBuildDeletedRequest(Run run) {
        return this.signRequest(new Request.Builder().delete().url(this.getHttpUrl("integration/" + JiraUtils.getJobHash(run) + "/" + run.getNumber())).build());
    }

    public Request createGetTunnelDetailsRequest() {
        return this.signRequest(new Request.Builder().get().url(this.getHttpUrl("integration/tunnel/" + this.getIdentifier())).build());
    }

    private HttpUrl getHttpUrl(String uri) {
        HttpUrl httpUrl = HttpUrl.get((URI)this.uri);
        if (httpUrl == null) {
            throw new IllegalStateException("Unable to get HttpUrl from " + String.valueOf(this.uri));
        }
        return httpUrl.newBuilder().addPathSegments(uri).build();
    }

    public Request signRequest(Request request) {
        return this.getSharedSecretCredentials().map(StringCredentials::getSecret).map(Secret::getPlainText).or(() -> Optional.ofNullable(this.sharedSecret)).filter(StringUtils::isNotBlank).map(sharedSecret -> {
            CanonicalHttpServletRequest canonicalHttpRequest = new CanonicalHttpServletRequest(request.method(), request.url().uri(), this.getContextPath());
            Request.Builder builder = request.newBuilder();
            SyncTokenBuilder syncTokenBuilder = new SyncTokenBuilder().identifier(this.identifier).sharedSecret(sharedSecret).request((CanonicalHttpRequest)canonicalHttpRequest);
            if (this.context != null && !this.context.isEmpty()) {
                syncTokenBuilder.context((Map)this.context);
            }
            syncTokenBuilder.generateTokenAndAddHeaders((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
            return builder.build();
        }).orElse(request);
    }

    private Optional<String> getContextPath() {
        return Optional.of(this.getUri().getPath()).map(path -> path.substring(0, path.indexOf("/rest/"))).filter(StringUtils::isNotBlank);
    }

    Domain getDomain() {
        return new Domain(this.uri.getHost(), "Jira Integration domain (autogenerated)", List.of(new SchemeSpecification(this.uri.getScheme()), new HostnameSpecification(this.uri.getHost(), null)));
    }

    public Optional<StringCredentials> getSharedSecretCredentials() {
        if (StringUtils.isNotBlank((CharSequence)this.sharedSecretId)) {
            List credentials = CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, List.of(new SchemeRequirement(this.getUri().getScheme()), new HostnameRequirement(this.getUri().getHost())));
            return Optional.ofNullable((StringCredentials)CredentialsMatchers.firstOrNull((Iterable)credentials, (CredentialsMatcher)CredentialsMatchers.withId((String)this.sharedSecretId)));
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.identifier, this.postJson);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraSite jiraSite = (JiraSite)o;
        return this.postJson == jiraSite.postJson && Objects.equals(this.uri, jiraSite.uri) && Objects.equals(this.identifier, jiraSite.identifier);
    }

    public String toString() {
        return "Jira site " + this.getName() + " at " + String.valueOf(this.uri);
    }

    public void updateSiteDetails(JSONObject details) {
        URI url = URI.create(details.getString("url"));
        if (!this.uri.equals(url)) {
            this.uri = url;
        }
        this.setName(details.getString("name"));
        JSONObject context = details.optJSONObject("context");
        if (context != null) {
            this.setContext(context);
        }
    }

    public static JiraSite getSite(JSONObject details) {
        JiraSite site = new JiraSite(URI.create(details.getString("url"))).withIdentifier(details.getString("identifier")).withName(details.getString("name")).withSharedSecret(details.getString("sharedSecret")).withPostJson(details.optBoolean("firewalled", false)).withTunneled(details.optBoolean("tunneled", false));
        JSONObject context = details.optJSONObject("context");
        if (context == null && details.has("contextJson")) {
            context = JSONObject.fromObject((Object)details.getString("contextJson"));
        }
        if (context != null) {
            site.setContext(context);
        }
        return site;
    }

    @Extension
    public static class Descriptor
    extends hudson.model.Descriptor<JiraSite> {
        @Nonnull
        public String getDisplayName() {
            return "Jira Site";
        }
    }
}

