/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.configuration;

import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import okhttp3.OkHttpClient;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.marvelution.jji.configuration.JiraSitesConfiguration;

@Extension
@Restricted(value={NoExternalUse.class})
public class DailyCheck
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(DailyCheck.class.getName());
    private JiraSitesConfiguration sitesConfiguration;
    private Provider<OkHttpClient> httpClient;

    public DailyCheck() {
        super("Daily Check");
    }

    @Inject
    public void setSitesConfiguration(JiraSitesConfiguration sitesConfiguration) {
        this.sitesConfiguration = sitesConfiguration;
    }

    @Inject
    public void setHttpClient(Provider<OkHttpClient> httpClient) {
        this.httpClient = httpClient;
    }

    public long getRecurrencePeriod() {
        return 86400000L;
    }

    public long getInitialDelay() {
        return 0L;
    }

    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        LOGGER.log(Level.INFO, "Checking Jira Sites...");
        this.sitesConfiguration.updateSiteRegistrations((OkHttpClient)this.httpClient.get());
    }
}

