/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.net;

import com.ngrok.Connection;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ConnectionOutputStream
extends OutputStream {
    private final Connection connection;
    private final ByteBuffer buffer;

    public ConnectionOutputStream(Connection connection, int bufferSize) {
        this.connection = connection;
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.put((byte)b);
        this.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int delta = Math.min(this.buffer.capacity(), len);
        for (int pos = 0; pos < len; pos += delta) {
            delta = Math.min(delta, len - pos);
            this.buffer.put(b, off + pos, delta);
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flip();
        this.connection.write(this.buffer);
        this.buffer.clear();
    }
}

