/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public interface Connection
extends AutoCloseable {
    public String getRemoteAddr();

    default public InetSocketAddress inetAddress() {
        String addr = this.getRemoteAddr();
        int lastColumn = addr.lastIndexOf(":");
        String host = addr.substring(0, lastColumn);
        String port = addr.substring(lastColumn + 1);
        return new InetSocketAddress(host, Integer.parseInt(port));
    }

    public int read(ByteBuffer var1) throws IOException;

    public int write(ByteBuffer var1) throws IOException;

    @Override
    public void close() throws IOException;

    public static interface Edge
    extends Connection {
        public String getEdgeType();

        public boolean isPassthroughTls();
    }

    public static interface Endpoint
    extends Connection {
        public String getProto();
    }
}

