/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;
import java.util.Locale;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

class Runtime {
    private static final Logger LOGGER = new Logger();

    Runtime() {
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    private static String getLibname() {
        String osname = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (osname.contains("nix") || osname.contains("nux")) {
            return "libngrok_java.so";
        }
        if (osname.contains("win")) {
            return "ngrok_java.dll";
        }
        if (osname.contains("mac")) {
            return "libngrok_java.dylib";
        }
        throw new RuntimeException("unknown OS: " + osname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        String filename = Runtime.getLibname();
        String tempDir = System.getProperty("java.io.tmpdir");
        File temporaryDir = new File(tempDir, "libngrok_" + System.nanoTime());
        temporaryDir.mkdir();
        temporaryDir.deleteOnExit();
        File temp = new File(temporaryDir, filename);
        try (InputStream is = Runtime.class.getResourceAsStream("/" + filename);){
            Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException | NullPointerException e) {
            temp.delete();
            throw new RuntimeException(e);
        }
        try {
            System.load(temp.getAbsolutePath());
        }
        finally {
            if (Runtime.isPosixCompliant()) {
                temp.delete();
            } else {
                temp.deleteOnExit();
            }
        }
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }

    static native void init(Logger var0);

    static class Logger {
        private static final org.slf4j.Logger logger = LoggerFactory.getLogger(Runtime.class);
        private static final String format = "[{}] {}";

        private Logger() {
        }

        public String getLevel() {
            Level[] levels;
            Level logLevel = Level.INFO;
            for (Level level : levels = new Level[]{Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE}) {
                if (!logger.isEnabledForLevel(level)) continue;
                logLevel = level;
            }
            return logLevel.toString();
        }

        public void log(String level, String target, String message) {
            Level lvl = Level.valueOf((String)level.toUpperCase());
            logger.atLevel(lvl).log(format, (Object)target, (Object)message);
        }
    }
}

