/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok;

import com.ngrok.EdgeBuilder;
import com.ngrok.HttpBuilder;
import com.ngrok.NativeEdgeForwarder;
import com.ngrok.NativeEdgeListener;
import com.ngrok.NativeHttpForwarder;
import com.ngrok.NativeHttpListener;
import com.ngrok.NativeTcpForwarder;
import com.ngrok.NativeTcpListener;
import com.ngrok.NativeTlsForwarder;
import com.ngrok.NativeTlsListener;
import com.ngrok.Runtime;
import com.ngrok.Session;
import com.ngrok.TcpBuilder;
import com.ngrok.TlsBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

public class NativeSession
implements Session {
    private static String version = "0.0.0-UNKNOWN";
    private long native_address;
    private final String id;
    private final String metadata;

    public NativeSession(String id, String metadata) {
        this.id = id;
        this.metadata = metadata;
    }

    public static NativeSession connect(Session.Builder builder) throws IOException {
        String jver = System.getProperty("java.version");
        builder.getClientInfos().add(0, new Session.ClientInfo("ngrok-java", version, jver));
        return NativeSession.connectNative(builder);
    }

    private static native NativeSession connectNative(Session.Builder var0) throws IOException;

    public String getId() {
        return this.id;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public native NativeTcpListener listenTcp(TcpBuilder var1) throws IOException;

    public native NativeTcpForwarder forwardTcp(TcpBuilder var1, URL var2) throws IOException;

    public native NativeTlsListener listenTls(TlsBuilder var1) throws IOException;

    public native NativeTlsForwarder forwardTls(TlsBuilder var1, URL var2) throws IOException;

    public native NativeHttpListener listenHttp(HttpBuilder var1) throws IOException;

    public native NativeHttpForwarder forwardHttp(HttpBuilder var1, URL var2) throws IOException;

    public native NativeEdgeListener listenEdge(EdgeBuilder var1) throws IOException;

    public native NativeEdgeForwarder forwardEdge(EdgeBuilder var1, URL var2) throws IOException;

    public native void closeListener(String var1) throws IOException;

    public native void closeForwarder(String var1) throws IOException;

    public native void close() throws IOException;

    static {
        try {
            Runtime.load();
            Runtime.init(Runtime.getLogger());
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        try {
            Properties props = new Properties();
            props.load(NativeSession.class.getResourceAsStream("/native.properties"));
            version = props.getProperty("agent.version", "0.0.0-SNAPSHOT");
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }
}

