/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.jwt;

import com.atlassian.connect.spring.internal.jwt.CanonicalHttpRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class HttpRequestCanonicalizer {
    public static final String QUERY_STRING_HASH_CLAIM_NAME = "qsh";
    public static final String JWT_PARAM_NAME = "jwt";
    public static final char QUERY_PARAMS_SEPARATOR = '&';
    private static final String ENCODED_PARAM_VALUE_SEPARATOR = ",";
    private static final char CANONICAL_REQUEST_PART_SEPARATOR = '&';

    public static String canonicalize(CanonicalHttpRequest request) throws UnsupportedEncodingException {
        return String.format("%s%s%s%s%s", HttpRequestCanonicalizer.canonicalizeMethod(request), Character.valueOf('&'), HttpRequestCanonicalizer.canonicalizeUri(request), Character.valueOf('&'), HttpRequestCanonicalizer.canonicalizeQueryParameters(request));
    }

    public static String computeCanonicalRequestHash(CanonicalHttpRequest request) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return HttpRequestCanonicalizer.computeSha256Hash(HttpRequestCanonicalizer.canonicalize(request));
    }

    private static String computeSha256Hash(String hashInput) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (null == hashInput) {
            throw new IllegalArgumentException("hashInput cannot be null");
        }
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hashInputBytes = hashInput.getBytes();
        digest.update(hashInputBytes, 0, hashInputBytes.length);
        return new String(Hex.encode((byte[])digest.digest()));
    }

    private static String canonicalizeUri(CanonicalHttpRequest request) throws UnsupportedEncodingException {
        String path = Optional.of(StringUtils.trimTrailingCharacter((String)request.getRelativePath(), (char)'/')).filter(s -> !ObjectUtils.isEmpty((Object)s)).orElse("/");
        String separatorAsString = String.valueOf('&');
        return (path = path.replaceAll(separatorAsString, HttpRequestCanonicalizer.percentEncode(separatorAsString))).startsWith("/") ? path : "/" + path;
    }

    private static String canonicalizeMethod(CanonicalHttpRequest request) {
        return StringUtils.capitalize((String)request.getMethod());
    }

    private static String canonicalizeQueryParameters(CanonicalHttpRequest request) throws UnsupportedEncodingException {
        String result = "";
        if (null != request.getParameterMap()) {
            ArrayList<ComparableParameter> parameterList = new ArrayList<ComparableParameter>(request.getParameterMap().size());
            for (Map.Entry<String, String[]> parameter : request.getParameterMap().entrySet()) {
                if (JWT_PARAM_NAME.equals(parameter.getKey())) continue;
                parameterList.add(new ComparableParameter(parameter));
            }
            Collections.sort(parameterList);
            result = HttpRequestCanonicalizer.percentEncode(HttpRequestCanonicalizer.getParameters(parameterList));
        }
        return result;
    }

    private static List<Map.Entry<String, String[]>> getParameters(Collection<ComparableParameter> parameters) {
        if (parameters == null) {
            return null;
        }
        ArrayList<Map.Entry<String, String[]>> list = new ArrayList<Map.Entry<String, String[]>>(parameters.size());
        for (ComparableParameter parameter : parameters) {
            list.add(parameter.parameter);
        }
        return list;
    }

    private static String percentEncode(Iterable<? extends Map.Entry<String, String[]>> parameters) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            HttpRequestCanonicalizer.percentEncode(parameters, b);
            return new String(b.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void percentEncode(Iterable<? extends Map.Entry<String, String[]>> parameters, OutputStream into) throws IOException {
        if (parameters != null) {
            boolean first = true;
            for (Map.Entry<String, String[]> entry : parameters) {
                if (first) {
                    first = false;
                } else {
                    into.write(38);
                }
                into.write(HttpRequestCanonicalizer.percentEncode(HttpRequestCanonicalizer.safeToString(entry.getKey())).getBytes());
                into.write(61);
                ArrayList<String> percentEncodedValues = new ArrayList<String>(entry.getValue().length);
                for (String value : entry.getValue()) {
                    percentEncodedValues.add(HttpRequestCanonicalizer.percentEncode(value));
                }
                String valueString = percentEncodedValues.stream().collect(Collectors.joining(ENCODED_PARAM_VALUE_SEPARATOR));
                into.write(valueString.getBytes());
            }
        }
    }

    private static String percentEncode(String value) throws UnsupportedEncodingException {
        if (value == null) {
            return "";
        }
        return URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }

    private static String safeToString(Object from) {
        return null == from ? null : from.toString();
    }

    private static class ComparableParameter
    implements Comparable<ComparableParameter> {
        final Map.Entry<String, String[]> parameter;
        private final String key;

        ComparableParameter(Map.Entry<String, String[]> parameter) throws UnsupportedEncodingException {
            this.parameter = parameter;
            String name = HttpRequestCanonicalizer.safeToString(parameter.getKey());
            List<Object> sortedValues = Arrays.asList((Object[])parameter.getValue());
            Collections.sort(sortedValues);
            String value = sortedValues.stream().collect(Collectors.joining(HttpRequestCanonicalizer.ENCODED_PARAM_VALUE_SEPARATOR));
            this.key = HttpRequestCanonicalizer.percentEncode(name) + ' ' + HttpRequestCanonicalizer.percentEncode(value);
        }

        @Override
        public int compareTo(ComparableParameter that) {
            return this.key.compareTo(that.key);
        }

        public String toString() {
            return this.key;
        }
    }
}

