/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.jwt;

import com.atlassian.connect.spring.internal.jwt.JwtExpiredException;
import com.atlassian.connect.spring.internal.jwt.JwtInvalidClaimException;
import com.atlassian.connect.spring.internal.jwt.JwtInvalidSigningAlgorithmException;
import com.atlassian.connect.spring.internal.jwt.JwtParseException;
import com.atlassian.connect.spring.internal.jwt.JwtSignatureMismatchException;
import com.atlassian.connect.spring.internal.jwt.JwtTooEarlyException;
import com.atlassian.connect.spring.internal.jwt.JwtVerificationException;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractJwtReader {
    private static final int TIME_CLAIM_LEEWAY_SECONDS = 30;
    private static final String UNEXPECTED_TYPE_MESSAGE_PREFIX = "Unexpected type of JSON object member with key ";
    private static final Set<String> NUMERIC_CLAIM_NAMES = new HashSet<String>(Arrays.asList("exp", "iat", "nbf"));
    private final JWSVerifier verifier;

    public AbstractJwtReader(JWSVerifier verifier) {
        this.verifier = verifier;
    }

    protected abstract Algorithm getSupportedAlgorithm();

    public JWTClaimsSet readAndVerify(String jwt, String queryStringHash) throws JwtParseException, JwtVerificationException {
        Object claim;
        JWTClaimsSet claims;
        JWSObject jwsObject = this.verify(jwt);
        try {
            claims = JWTClaimsSet.parse((String)jwsObject.getPayload().toString());
        }
        catch (ParseException e) {
            if (e.getMessage().startsWith(UNEXPECTED_TYPE_MESSAGE_PREFIX)) {
                String claimName = e.getMessage().replace(UNEXPECTED_TYPE_MESSAGE_PREFIX, "").replaceAll("\"", "");
                if (NUMERIC_CLAIM_NAMES.contains(claimName)) {
                    throw new JwtInvalidClaimException(String.format("Expecting claim '%s' to be numeric but it is a string", claimName), e);
                }
                throw new JwtParseException("Perhaps a claim is of the wrong type (e.g. expecting integer but found string): " + e.getMessage(), e);
            }
            throw new JwtParseException(e);
        }
        if (claims.getIssueTime() == null || claims.getExpirationTime() == null) {
            throw new JwtInvalidClaimException("'exp' and 'iat' are required claims. Atlassian JWT does not allow JWTs with unlimited lifetimes.");
        }
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(13, -30);
        Date nowMinusLeeway = calendar.getTime();
        calendar.setTime(now);
        calendar.add(13, 30);
        Date nowPlusLeeway = calendar.getTime();
        if (null != claims.getNotBeforeTime()) {
            if (!claims.getExpirationTime().after(claims.getNotBeforeTime())) {
                throw new JwtInvalidClaimException(String.format("The expiration time must be after the not-before time but exp=%s and nbf=%s", claims.getExpirationTime(), claims.getNotBeforeTime()));
            }
            if (claims.getNotBeforeTime().after(nowPlusLeeway)) {
                throw new JwtTooEarlyException(claims.getNotBeforeTime(), now, 30);
            }
        }
        if (claims.getExpirationTime().before(nowMinusLeeway)) {
            throw new JwtExpiredException(claims.getExpirationTime(), now, 30);
        }
        if (queryStringHash != null && (claim = claims.getClaim("qsh")) != null && !queryStringHash.equals(claim)) {
            throw new JwtInvalidClaimException(String.format("Expecting claim '%s' to have value '%s' but instead it has the value '%s'", "qsh", queryStringHash, claim));
        }
        return claims;
    }

    private JWSObject verify(String jwt) throws JwtParseException, JwtVerificationException {
        try {
            JWSObject jwsObject = JWSObject.parse((String)jwt);
            JWSAlgorithm algorithm = jwsObject.getHeader().getAlgorithm();
            if (!this.getSupportedAlgorithm().equals((Object)algorithm)) {
                throw new JwtInvalidSigningAlgorithmException(String.format("Expected JWT to be signed with '%s' but it was signed with '%s' instead", this.getSupportedAlgorithm(), algorithm));
            }
            if (!jwsObject.verify(this.verifier)) {
                throw new JwtSignatureMismatchException(jwt);
            }
            return jwsObject;
        }
        catch (ParseException e) {
            throw new JwtParseException(e);
        }
        catch (JOSEException e) {
            throw new JwtSignatureMismatchException((Exception)((Object)e));
        }
    }
}

