/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model.adapters.javax;

import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang3.StringUtils;

public class TrailingSlashURIAdapter
extends XmlAdapter<String, URI> {
    @Nullable
    public URI unmarshal(String v) {
        return StringUtils.isNotBlank((CharSequence)v) ? URI.create(this.checkTrailingSlash(v)) : null;
    }

    @Nullable
    public String marshal(URI v) {
        return v != null ? this.checkTrailingSlash(v.toASCIIString()) : null;
    }

    @Nonnull
    private String checkTrailingSlash(String uri) {
        return StringUtils.stripEnd((String)uri, (String)"/") + "/";
    }
}

