/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model;

import jakarta.xml.bind.annotation.XmlAccessorType;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@jakarta.xml.bind.annotation.XmlRootElement
@XmlAccessorType(value=jakarta.xml.bind.annotation.XmlAccessType.FIELD)
@XmlRootElement
@javax.xml.bind.annotation.XmlAccessorType(value=XmlAccessType.FIELD)
public class ConfigurationSetting {
    public static final String GLOBAL_SCOPE = "";
    private String scope = "";
    private String key;
    private String value;
    private boolean overridable = true;
    private boolean internal = false;

    public static ConfigurationSetting forKey(String key) {
        return new ConfigurationSetting().setKey(key);
    }

    public String getScope() {
        return this.scope;
    }

    public ConfigurationSetting setScope(String scope) {
        this.scope = scope == null ? GLOBAL_SCOPE : scope;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public ConfigurationSetting setKey(String key) {
        this.key = key;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public ConfigurationSetting setValue(String value) {
        this.value = value != null ? value : GLOBAL_SCOPE;
        return this;
    }

    public ConfigurationSetting setValue(Integer value) {
        return this.setValue(Integer.toString(value));
    }

    public ConfigurationSetting setValue(Boolean value) {
        return this.setValue(Boolean.toString(value));
    }

    public Optional<Integer> valueAsInteger() {
        return this.valueAs(v -> {
            try {
                return Integer.valueOf(v);
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
    }

    public Optional<Boolean> valueAsBoolean() {
        return this.valueAs(Boolean::valueOf);
    }

    public <T> Optional<T> valueAs(Function<String, T> function) {
        return Optional.ofNullable(this.value).filter(StringUtils::isNotBlank).map(function);
    }

    public boolean isOverridable() {
        return this.overridable;
    }

    public ConfigurationSetting setOverridable(boolean overridable) {
        this.overridable = overridable;
        return this;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public ConfigurationSetting setInternal(boolean internal) {
        this.internal = internal;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.scope, this.key, this.value, this.overridable, this.internal);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationSetting that = (ConfigurationSetting)o;
        return this.overridable == that.overridable && this.internal == that.internal && Objects.equals(this.key, that.key) && Objects.equals(this.scope, that.scope) && Objects.equals(this.value, that.value);
    }

    public String toString() {
        return new StringJoiner(", ", ConfigurationSetting.class.getSimpleName() + "[", "]").add("scope='" + this.scope + "'").add("key='" + this.key + "'").add("value='" + this.value + "'").add("overridable=" + this.overridable).add("internal=" + this.internal).toString();
    }
}

