/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.synctoken;

import com.atlassian.connect.spring.internal.jwt.CanonicalHttpRequest;
import com.atlassian.connect.spring.internal.jwt.HttpRequestCanonicalizer;
import com.atlassian.connect.spring.internal.jwt.JwtJsonBuilder;
import com.atlassian.connect.spring.internal.jwt.JwtWriter;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.MACSigner;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.function.BiConsumer;

public class SyncTokenBuilder {
    private static final long EXPIRATION_TIME = 180L;
    private final JwtJsonBuilder jwtBuilder;
    private String sharedSecret;

    public SyncTokenBuilder() {
        this(180L);
    }

    public SyncTokenBuilder(long expirationTime) {
        this.jwtBuilder = new JwtJsonBuilder(Duration.of(expirationTime, ChronoUnit.SECONDS));
    }

    public SyncTokenBuilder identifier(String identifier) {
        this.jwtBuilder.issuer(identifier);
        return this;
    }

    public SyncTokenBuilder sharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
        return this;
    }

    public SyncTokenBuilder context(Map<String, Object> context) {
        this.jwtBuilder.claim("context", context);
        return this;
    }

    public SyncTokenBuilder claim(String name, Object claim) {
        this.jwtBuilder.claim(name, claim);
        return this;
    }

    public SyncTokenBuilder request(CanonicalHttpRequest request) {
        try {
            this.jwtBuilder.queryHash(HttpRequestCanonicalizer.computeCanonicalRequestHash((CanonicalHttpRequest)request));
            return this;
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String generateToken() {
        try {
            return new JwtWriter(JWSAlgorithm.HS256, (JWSSigner)new MACSigner(this.sharedSecret)).jsonToJwt(this.jwtBuilder.build());
        }
        catch (KeyLengthException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void generateTokenAndAddHeaders(BiConsumer<String, String> headerSetter) {
        String token = this.generateToken();
        headerSetter.accept("X-Sync-Token", token);
        headerSetter.accept("X-JJI-Sync-Token", token);
    }
}

