/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.synctoken;

import com.atlassian.connect.spring.internal.jwt.CanonicalHttpRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class CanonicalHttpServletRequest
implements CanonicalHttpRequest {
    private static final Pattern QUERY_PARAM_PATTERN = Pattern.compile("([^&=]+)(=?)([^&]+)?");
    private static final String SLASH = "/";
    private final String method;
    private final String relativePath;
    private final Map<String, String[]> parameters;

    public CanonicalHttpServletRequest(String method, URI uri, Optional<String> contextPath) {
        this.method = method.toUpperCase(Locale.ENGLISH);
        String contextPathToRemove = contextPath.filter(path -> !SLASH.equals(path)).map(path -> StringUtils.stripEnd((String)path, (String)SLASH)).orElse("");
        this.relativePath = CanonicalHttpServletRequest.getRelativePath(uri, contextPathToRemove);
        this.parameters = CanonicalHttpServletRequest.parseQueryString(uri.getRawQuery());
    }

    public CanonicalHttpServletRequest(String method, String relativePath, String rawQueryString) {
        this.method = method;
        this.relativePath = relativePath;
        this.parameters = CanonicalHttpServletRequest.parseQueryString(rawQueryString);
    }

    public static String getRelativePath(URI uri, String contextPath) {
        return (String)StringUtils.defaultIfBlank((CharSequence)StringUtils.removeEnd((String)StringUtils.removeStart((String)uri.getPath(), (String)contextPath), (String)SLASH), (CharSequence)SLASH);
    }

    private static Map<String, String[]> parseQueryString(@Nullable String queryString) {
        HashMap<String, List> parameters = new HashMap<String, List>();
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            Matcher matcher = QUERY_PARAM_PATTERN.matcher(queryString);
            while (matcher.find()) {
                String value;
                String name = matcher.group(1);
                String eq = matcher.group(2);
                parameters.computeIfAbsent(name, key -> new ArrayList()).add((value = matcher.group(3)) != null ? value : (StringUtils.length((CharSequence)eq) > 0 ? "" : null));
            }
        }
        return parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).toArray(new String[0])));
    }

    public String getMethod() {
        return this.method;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("method='" + this.method + "'").add("relativePath='" + this.relativePath + "'").add("parameters=" + this.parameters).toString();
    }
}

