/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model.parsers;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.marvelution.jji.model.Build;
import org.marvelution.jji.model.parsers.BuildActionParser;
import org.marvelution.jji.model.parsers.BuildGitBranchesParser;
import org.marvelution.jji.model.parsers.ParserUtils;

class BuildScmRevisionParser
extends BuildActionParser {
    private static final String REVISION = "revision";

    protected BuildScmRevisionParser() {
        super("jenkins.scm.api.SCMRevisionAction", REVISION);
    }

    @Override
    protected void parse(JsonObject json, Build target) {
        JsonObject revision = json.asJsonObject().getJsonObject(REVISION);
        JsonObject head = revision.getJsonObject("head");
        Optional.ofNullable(head).flatMap(h -> ParserUtils.optString(h, "name")).ifPresent(target.getBranches()::add);
    }

    @Override
    protected boolean handleMisMatch(JsonValue json, Build target) {
        return new BuildGitBranchesParser().parse(json, target);
    }

    @Override
    public List<String> fields() {
        return Collections.singletonList("revision[*,head[*]]");
    }
}

