/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model.parsers;

import jakarta.json.JsonObject;
import java.util.Collections;
import java.util.List;
import org.marvelution.jji.model.Build;
import org.marvelution.jji.model.DeploymentEnvironment;
import org.marvelution.jji.model.DeploymentEnvironmentType;
import org.marvelution.jji.model.parsers.BuildActionParser;

class BuildDeploymentEnvironmentParser
extends BuildActionParser {
    private static final String ENVIRONMENT = "environment";
    private static final String DEPLOYMENT_ENVIRONMENT_ACTION = "org.marvelution.jji.export.DeploymentEnvironmentAction";

    public BuildDeploymentEnvironmentParser() {
        super(DEPLOYMENT_ENVIRONMENT_ACTION, ENVIRONMENT);
    }

    @Override
    protected void parse(JsonObject json, Build target) {
        JsonObject object = json.asJsonObject().getJsonObject(ENVIRONMENT);
        String id = object.getString("id");
        String name = object.getString("name");
        DeploymentEnvironmentType type = DeploymentEnvironmentType.fromString((String)object.getString("type"));
        target.getDeploymentEnvironments().add(new DeploymentEnvironment().setId(id).setName(name).setType(type));
    }

    @Override
    public List<String> fields() {
        return Collections.singletonList("environment[*]");
    }
}

