'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FileSize = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var oneOfType = _react.PropTypes.oneOfType,
    number = _react.PropTypes.number,
    string = _react.PropTypes.string;

var units = ['bytes', 'KB', 'MB', 'GB', 'TB', 'PB'];

// Polyfill for old browsers and IE
// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/log10
var log10 = Math.log10 || function (x) {
    return Math.log(x) / Math.LN10;
};

var FileSize = exports.FileSize = function (_Component) {
    _inherits(FileSize, _Component);

    function FileSize() {
        _classCallCheck(this, FileSize);

        return _possibleConstructorReturn(this, (FileSize.__proto__ || Object.getPrototypeOf(FileSize)).apply(this, arguments));
    }

    _createClass(FileSize, [{
        key: 'render',
        value: function render() {
            var bytes = this.props.bytes;

            var output = '-';

            if (typeof bytes == 'string') {
                bytes = parseInt(bytes);
            }

            if (bytes === 0) {
                output = '0 ' + units[0];
            } else if (!isNaN(bytes)) {
                // calculate the unit (e.g. 'MB') to display
                // but ensure it doesn't go over the max we support
                var power = Math.floor(log10(Math.abs(bytes)) / log10(1024));
                power = Math.min(power, units.length - 1);

                // round displayed value to one decimal place
                var value = Math.round(bytes / Math.pow(1024, power) * 10) / 10;
                output = value + ' ' + units[power];
            }

            return _react2.default.createElement(
                'span',
                null,
                output
            );
        }
    }]);

    return FileSize;
}(_react.Component);

FileSize.propTypes = {
    bytes: oneOfType([number, string])
};
//# sourceMappingURL=FileSize.js.map
