'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _PipelineGraph = require('../components/pipeline/PipelineGraph');

var _components = require('../components');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var validResultValues = _components.StatusIndicator.validResultValues;

(0, _storybook.storiesOf)('PipelineGraph', module).add('Mixed', renderMultiParallelPipeline).add('Multi-stage Parallel', renderMultiStageParallel).add('Multi-stage Spacing', renderMultiStageSpacing).add('Edge cases 1', renderEdgeCases1).add('Long names', renderLongNames).add('Duplicate Names', renderWithDuplicateNames).add('Fat', renderFlatPipelineFat).add('Legend', renderFlatPipeline).add('Listeners', renderListenersPipeline).add('Parallel', renderParallelPipeline).add('Parallel (Deep)', renderParallelPipelineDeep);

function renderFlatPipeline() {

    var stages = [makeNode('Success', [], validResultValues.success), makeNode('Failure', [], validResultValues.failure), makeNode('Running', [], validResultValues.running), makeNode('Slow', [], validResultValues.running, 150), makeNode('Queued', [], validResultValues.queued), makeNode('Unstable', [], validResultValues.unstable), makeNode('Aborted', [], validResultValues.aborted), makeNode('Not Built', [], validResultValues.not_built), makeNode('Bad data', [], 'this is not my office')];

    // Reduce spacing just to make this graph smaller
    var layout = { nodeSpacingH: 90 };

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages, layout: layout })
    );
}

function renderWithDuplicateNames() {

    var stages = [makeNode('Build'), makeNode('Test'), makeNode('Browser Tests', [makeNode('Internet Explorer'), makeNode('Chrome')]), makeNode('Test'), makeNode('Staging'), makeNode('Production')];

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages })
    );
}

function renderFlatPipelineFat() {

    var stages = [makeNode('Success', [], validResultValues.success), makeNode('Failure', [], validResultValues.failure), makeNode('Running', [makeNode('Job 1', [], validResultValues.running), makeNode('Job 2', [], validResultValues.running), makeNode('Job 3', [], validResultValues.running)]), makeNode('Queued', [makeNode('Job 4', [], validResultValues.queued), makeNode('Job 5', [], validResultValues.queued), makeNode('Job 6', [], validResultValues.queued), makeNode('Job 7', [], validResultValues.queued), makeNode('Job 8', [], validResultValues.queued)]), makeNode('Not Built', [], validResultValues.not_built), makeNode('Bad data', [], 'this is not my office')];

    var layout = {
        connectorStrokeWidth: 10,
        nodeRadius: 20,
        curveRadius: 10
    };

    return _react2.default.createElement(
        'div',
        { style: { padding: 10 } },
        _react2.default.createElement(
            'h1',
            null,
            'Same data, different layout'
        ),
        _react2.default.createElement(
            'h3',
            null,
            'Normal'
        ),
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages }),
        _react2.default.createElement(
            'h3',
            null,
            'Fat'
        ),
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages, layout: layout })
    );
}

function renderListenersPipeline() {

    var stages = [makeNode('Build', [], validResultValues.success), makeNode('Test', [], validResultValues.success), makeNode('Browser Tests', [makeNode('Internet Explorer', [], validResultValues.queued), makeNode('Chrome', [], validResultValues.queued)]), makeNode('Dev'), makeNode('Dev'), // Make sure it works with dupe names
    makeNode('Staging'), makeNode('Production')];

    function nodeClicked() {
        for (var _len = arguments.length, values = Array(_len), _key = 0; _key < _len; _key++) {
            values[_key] = arguments[_key];
        }

        console.log('Node clicked', values);
    }

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages, onNodeClick: nodeClicked })
    );
}

function renderParallelPipeline() {

    var stages = [makeNode('Build'), makeNode('Test'), makeNode('Browser Tests', [makeNode('Internet Explorer'), makeNode('Chrome')]), makeNode('Dev but with long label'), makeNode('Staging'), makeNode('Production')];

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages })
    );
}

function renderMultiStageParallel() {

    var stages = [makeNode('Alpha'), makeNode('Bravo', [makeNode('Single 1'), makeNode('Single 2'), makeNode('Single 3'), makeSequence(makeNode('Multi 1 of 3'), makeNode('Multi 2 of 3'), makeNode('Multi 3 of 3')), makeSequence(makeNode('Multi 1 of 2'), makeNode('Multi 2 of 2')), makeSequence(makeNode('Multi 1 of 4'), makeNode('Multi 2 of 4'), makeNode('Multi 3 of 4'), makeNode('Multi 4 of 4')), makeNode('Single 4')]), makeNode('Charlie'), makeNode('Delta')];

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages })
    );
}

function renderMultiStageSpacing() {

    var stages = [makeNode('Alpha', [makeNode('Homer'), makeNode('Marge')]), makeNode('Blue'), makeNode('Bravo', [makeNode('Single 1'), makeSequence(makeNode('xxxxxxxxxxxxxxxxxxxxxxxxxx'), makeNode('xxxxxxxxxxxxxxxxxxxxxxxxxx'), makeNode('xxxxxxxxxxxxxxxxxxxxxxxxxx')), makeSequence(makeNode('Multi 1 of 4'), makeNode('Multi 2 of 4'), makeNode('Multi 3 of 4'), makeNode('Multi 4 of 4'))])];

    return _react2.default.createElement(
        'div',
        { style: { padding: '2em' } },
        _react2.default.createElement(
            'h3',
            null,
            '120px (normal)'
        ),
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages, layout: { parallelSpacingH: 120 } }),
        _react2.default.createElement(
            'h3',
            null,
            '100px'
        ),
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages, layout: { parallelSpacingH: 100 } }),
        _react2.default.createElement(
            'h3',
            null,
            '95px'
        ),
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages, layout: { parallelSpacingH: 95 } })
    );
}

function renderEdgeCases1() {

    var stages1 = [makeNode('Alpha', [], validResultValues.skipped), makeNode('Bravo', [], validResultValues.success), makeNode('Charlie', [], validResultValues.skipped)];

    var stages2 = [makeNode('Alpha', [makeNode('Delta', [], validResultValues.success), makeNode('Echo', [], validResultValues.success), makeNode('Foxtrot', [], validResultValues.success)]), makeNode('Bravo', [], validResultValues.success), makeNode('Charlie', [makeNode('Golf', [], validResultValues.success), makeNode('Hotel', [], validResultValues.success), makeNode('Indigo', [], validResultValues.success)])];

    var stages3 = [makeNode('Alpha', [], validResultValues.success), makeNode('Bravo', [], validResultValues.skipped), makeNode('Charlie', [], validResultValues.skipped)];

    var stages4 = [makeNode('Alpha', [makeNode('Single 1'), makeSequence(makeNode('Multi 1 of 3'), makeNode('Multi 2 of 3'), makeNode('Multi 3 of 3')), makeSequence(makeNode('Multi 1 of 2'), makeNode('Multi 2 of 2')), makeNode('Single 2')]), makeNode('Bravo', [], validResultValues.skipped), makeNode('Charlie', [makeNode('Single 1'), makeSequence(makeNode('Multi 1 of 2'), makeNode('Multi 2 of 2')), makeNode('Single 2')])];

    var stages5 = [makeNode('Alpha', [makeNode('Single 1'), makeSequence(makeNode('Multi 1 of 3'), makeNode('Multi 2 of 3'), makeNode('Multi 3 of 3')), makeSequence(makeNode('Multi 1 of 2'), makeNode('Multi 2 of 2')), makeNode('Single 2')]), makeNode('Bravo'), makeNode('Charlie', [makeNode('Single 1'), makeSequence(makeNode('Multi 1 of 2'), makeNode('Multi 2 of 2')), makeNode('Single 2')])];

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages1, selectedStage: stages1[1] }),
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages2, selectedStage: stages2[1] }),
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages3, selectedStage: stages3[0] }),
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages4, selectedStage: stages4[0].children[1].nextSibling.nextSibling }),
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages5, selectedStage: stages5[0].children[2] })
    );
}

function renderMultiParallelPipeline() {

    var stages = [makeNode('Build', [], validResultValues.success), makeNode('Test', [makeNode('JUnit', [], validResultValues.success), makeNode('DBUnit', [], validResultValues.success), makeNode('Jasmine', [], validResultValues.success)]), makeNode('Browser Tests', [makeNode('Firefox', [], validResultValues.success), makeNode('Edge', [], validResultValues.failure), makeNode('Safari', [], validResultValues.running, 60), makeNode('Chrome', [], validResultValues.running, 120)]), makeNode('Skizzled', [], validResultValues.skipped), makeNode('Foshizzle', [], validResultValues.skipped), makeNode('Dev', [makeNode('US-East', [], validResultValues.success), makeNode('US-West', [], validResultValues.success), makeNode('APAC', [], validResultValues.success)], validResultValues.success), makeNode('Staging', [], validResultValues.skipped), makeNode('Production')];

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages, selectedStage: stages[0] })
    );
}

function renderLongNames() {

    var stages = [makeNode('Build something with a long and descriptive name that takes up a shitload of space', [], validResultValues.success), makeNode('Test', [makeNode('JUnit', [], validResultValues.success), makeNode('DBUnit', [], validResultValues.success), makeNode('Jasmine', [], validResultValues.success)]), makeNode('Browser Tests', [makeNode('Firefox', [], validResultValues.success), makeNode('Das komputermaschine ist nicht auf mittengraben unt die gerfingerpoken. Watchen das blinkenlights.', [], validResultValues.failure), makeNode('RubberbabybuggybumpersbetyoudidntknowIwasgoingtodothat', [], validResultValues.running, 60), makeNode('Chrome', [], validResultValues.running, 120)]), makeNode('Dev'), makeNode('Staging'), makeNode('Production')];

    var stages2 = [makeNode('Alpha', [makeNode('Single 1'), makeSequence(makeNode('RubberbabybuggybumpersbetyoudidntknowIwasgoingtodothat'), makeNode('.............................................................................................'), makeNode('Das komputermaschine ist nicht auf mittengraben unt die gerfingerpoken. Watchen das blinkenlights.')), makeSequence(makeNode('Multi 1 of 2'), makeNode('Multi 2 of 2')), makeNode('Single 2')]), makeNode('Bravo'), makeNode('Charlie', [makeNode('Single 1'), makeSequence(makeNode('Multi 1 of 2'), makeNode('Multi 2 of 2')), makeNode('Single 2')])];

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages, selectedStage: stages[0] }),
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages2, selectedStage: stages2[0] })
    );
}

function renderParallelPipelineDeep() {

    var stages = [makeNode('Build', [], validResultValues.success), makeNode('Test', [], validResultValues.success), makeNode('Browser Tests', [makeNode('Internet Explorer', [], validResultValues.success), makeNode('Firefox', [], validResultValues.running), makeNode('Edge', [], validResultValues.failure), makeNode('Safari', [], validResultValues.running), makeNode('LOLpera', [], validResultValues.queued), makeNode('Chrome', [], validResultValues.queued)]), makeNode('Dev', [], validResultValues.not_built), makeNode('Staging', [], validResultValues.not_built), makeNode('Production', [], validResultValues.not_built)];

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(_PipelineGraph.PipelineGraph, { stages: stages })
    );
}

var __id = 1;

/// Simple helper for data generation
function makeNode(name) {
    var children = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    var state = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : validResultValues.not_built;
    var completePercent = arguments[3];

    completePercent = completePercent || (state == validResultValues.running ? Math.floor(Math.random() * 60 + 20) : 50);
    var id = __id++;
    return { name: name, children: children, state: state, completePercent: completePercent, id: id };
}

function makeSequence() {
    for (var _len2 = arguments.length, stages = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        stages[_key2] = arguments[_key2];
    }

    for (var i = 0; i < stages.length - 1; i++) {
        stages[i].nextSibling = stages[i + 1];
    }

    return stages[0]; // The model only needs the first in a sequence
}
//# sourceMappingURL=PipelineGraphStories.js.map
