'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _ErrorMessage = require('../components/ErrorMessage');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('ErrorMessage', module).add('sizes', function () {
    return _react2.default.createElement(Sizes, null);
});

var style = {
    padding: 10
};

// Sizes

// show several ErrorMessages w/ spacing
function ErrorMessageGroup(props) {
    var count = props.count || 3;
    var array = new Array(count);

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.Children.map(array, function (item, index) {
            return _react2.default.createElement(
                _ErrorMessage.ErrorMessage,
                null,
                'Error Message #',
                index
            );
        })
    );
}

ErrorMessageGroup.propTypes = {
    count: _react.PropTypes.number
};

function Sizes() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using no layout'
            ),
            _react2.default.createElement(ErrorMessageGroup, null)
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-small', style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using layout-small'
            ),
            _react2.default.createElement(ErrorMessageGroup, null)
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-medium', style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using layout-medium'
            ),
            _react2.default.createElement(ErrorMessageGroup, null)
        ),
        _react2.default.createElement(
            'div',
            { className: 'layout-large', style: style },
            _react2.default.createElement(
                'p',
                null,
                'Using layout-large'
            ),
            _react2.default.createElement(ErrorMessageGroup, null)
        )
    );
}
//# sourceMappingURL=ErrorMessageStories.js.map
