'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TextControl = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Contains common logic for text-based controls.
 * Not intended to be used directly.
 */
var TextControl = exports.TextControl = function (_React$Component) {
    _inherits(TextControl, _React$Component);

    function TextControl(props) {
        _classCallCheck(this, TextControl);

        var _this = _possibleConstructorReturn(this, (TextControl.__proto__ || Object.getPrototypeOf(TextControl)).call(this, props));

        _this.state = {
            value: ''
        };
        return _this;
    }

    _createClass(TextControl, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
            this._initialize(this.props);
        }
    }, {
        key: '_initialize',
        value: function _initialize(props) {
            if (props.defaultValue) {
                this.setState({
                    value: props.defaultValue
                });
            }
        }
    }, {
        key: '_onChange',
        value: function _onChange(event) {
            var value = event.currentTarget.value;


            this.setState({
                value: value
            });

            if (this.props.onChange) {
                this.props.onChange(value);
            }
        }
    }, {
        key: '_onBlur',
        value: function _onBlur(event) {
            var value = event.currentTarget.value;


            if (this.props.onBlur) {
                this.props.onBlur(value);
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            return _react2.default.createElement(
                'div',
                { className: this.props.className },
                _react2.default.Children.map(this.props.children, function (child) {
                    // while multiple children can be passed in (icons, etc)
                    // we only want to pass down props to underlying text control
                    if (child && (child.type === 'input' || child.type === 'textarea')) {
                        return _react2.default.cloneElement(child, {
                            placeholder: _this2.props.placeholder,
                            disabled: _this2.props.disabled,
                            value: _this2.state.value,
                            onChange: function onChange(e) {
                                return _this2._onChange(e);
                            },
                            onBlur: function onBlur(e) {
                                return _this2._onBlur(e);
                            }
                        });
                    }

                    return child;
                })
            );
        }
    }, {
        key: 'value',
        get: function get() {
            return this.state.value;
        }
    }]);

    return TextControl;
}(_react2.default.Component);

TextControl.propTypes = {
    children: _react.PropTypes.node,
    className: _react.PropTypes.string,
    placeholder: _react.PropTypes.string,
    defaultValue: _react.PropTypes.string,
    disabled: _react.PropTypes.bool,
    onChange: _react.PropTypes.func,
    onBlur: _react.PropTypes.func
};

TextControl.defaultProps = {
    className: 'TextControl'
};
//# sourceMappingURL=TextControl.js.map
