'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Favorite = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Checkbox = require('../forms/Checkbox');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Favorite = exports.Favorite = function (_Component) {
    _inherits(Favorite, _Component);

    function Favorite() {
        _classCallCheck(this, Favorite);

        return _possibleConstructorReturn(this, (Favorite.__proto__ || Object.getPrototypeOf(Favorite)).apply(this, arguments));
    }

    _createClass(Favorite, [{
        key: 'render',
        value: function render() {
            var _this2 = this;

            var extraClass = this.props.className || '';

            return _react2.default.createElement(
                _Checkbox.Checkbox,
                {
                    ref: function ref(checkbox) {
                        _this2.checkbox = checkbox;
                    },
                    className: 'Favorite ' + extraClass,
                    checked: this.props.checked,
                    onToggle: this.props.onToggle,
                    label: this.props.label
                },
                _react2.default.createElement(FavoriteStarSvg, { checked: this.props.checked })
            );
        }
    }, {
        key: 'checked',
        get: function get() {
            return this.checkbox.checked;
        }
    }]);

    return Favorite;
}(_react.Component);

Favorite.defaultProps = {
    checked: false,
    className: ''
};


Favorite.propTypes = {
    className: _react.PropTypes.oneOf(['', 'dark']),
    checked: _react.PropTypes.bool,
    label: _react.PropTypes.string,
    onToggle: _react.PropTypes.func
};

/* eslint-disable max-len */
function FavoriteStarSvg(checkedObj) {
    var checked = checkedObj.checked;

    return _react2.default.createElement(
        'div',
        { title: checked ? 'Remove Favourite' : 'Favourite' },
        _react2.default.createElement(
            'svg',
            { className: 'star-icon', width: '288', height: '24', viewBox: '0 0 288 24', xmlns: 'http://www.w3.org/2000/svg', focusable: 'false' },
            _react2.default.createElement(
                'g',
                { fill: 'none', fillRule: 'evenodd' },
                _react2.default.createElement('path', {
                    className: 'Favorite-fill star-empty',
                    d: 'M22 9.24l-7.19-.62L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21 12 17.27 18.18 21l-1.63-7.03L22 9.24zM12 15.4l-3.76 2.27 1-4.28-3.32-2.88 4.38-.38L12 6.1l1.71 4.04 4.38.38-3.32 2.88 1 4.28L12 15.4z'
                }),
                _react2.default.createElement('path', { d: 'M0 0h24v24H0V0zM49-1h24v24H49V-1z' }),
                _react2.default.createElement('path', { d: 'M49-1h24v24H49V-1zM144 0h24v24h-24V0z' }),
                _react2.default.createElement('path', { d: 'M144 0h24v24h-24V0z' }),
                _react2.default.createElement(
                    'g',
                    { className: 'Favorite-stroke--selected', strokeWidth: '.8', strokeLinecap: 'square' },
                    _react2.default.createElement('path', { d: 'M153 8l-1.5-1.5M159 8l1.5-1.5M151.051 14.054l-1.576 1.42M162.46 15.038L161 14M155.691 18.849l.02-1.12' })
                ),
                _react2.default.createElement('path', {
                    d: 'M156 15.689l4.326 2.611-1.148-4.921L163 10.068l-5.033-.427L156 5l-1.967 4.641-5.033.427 3.822 3.311-1.148 4.921L156 15.689z',
                    className: 'Favorite-fill--selected'
                }),
                _react2.default.createElement('path', { d: 'M24 0h24v24H24V0z' }),
                _react2.default.createElement('path', { d: 'M24 0h24v24H24V0z' }),
                _react2.default.createElement('path', {
                    d: 'M36 14.635l3.09 1.865-.82-3.515L41 10.62l-3.595-.305L36 7l-1.405 3.315L31 10.62l2.73 2.365-.82 3.515L36 14.635z',
                    className: 'Favorite-fill--selected',
                    opacity: '.72'
                }),
                _react2.default.createElement('path', { d: 'M48 0h24v24H48V0z' }),
                _react2.default.createElement('path', { d: 'M48 0h24v24H48V0z' }),
                _react2.default.createElement('path', {
                    d: 'M60.5 15.399l3.399 2.051-.902-3.866L66 10.982l-3.954-.335L60.5 7l-1.546 3.646-3.954.336 3.003 2.602-.902 3.866 3.399-2.051z',
                    className: 'Favorite-fill--selected',
                    opacity: '.82'
                }),
                _react2.default.createElement('path', { d: 'M72 0h24v24H72V0z' }),
                _react2.default.createElement('path', { d: 'M72 0h24v24H72V0z' }),
                _react2.default.createElement('path', {
                    d: 'M84 15.162l3.708 2.238-.984-4.218L90 10.344l-4.314-.366L84 6l-1.686 3.978-4.314.366 3.276 2.838-.984 4.218L84 15.162z',
                    className: 'Favorite-fill--selected',
                    opacity: '.85'
                }),
                _react2.default.createElement('path', { d: 'M96 0h24v24H96V0z' }),
                _react2.default.createElement('path', { d: 'M96 0h24v24H96V0z' }),
                _react2.default.createElement('path', {
                    d: 'M108.5 15.925l4.017 2.425-1.066-4.57L115 10.707l-4.674-.396L108.5 6l-1.826 4.31-4.674.396 3.549 3.075-1.066 4.569 4.017-2.425z',
                    className: 'Favorite-fill--selected'
                }),
                _react2.default.createElement(
                    'g',
                    { className: 'Favorite-stroke--selected', strokeWidth: '.5', strokeLinecap: 'square' },
                    _react2.default.createElement('path', { d: 'M107 11l-1.5-1.5M110 11l1.5-1.5M106.051 13.054l-1.576 1.42M112.46 14.038L111 13M108.691 16.849l.02-1.12' })
                ),
                _react2.default.createElement(
                    'g',
                    null,
                    _react2.default.createElement('path', { d: 'M120 0h24v24h-24V0z' }),
                    _react2.default.createElement('path', { d: 'M120 0h24v24h-24V0z' }),
                    _react2.default.createElement('path', {
                        d: 'M131.75 15.307l4.171 2.518-1.106-4.745 3.685-3.193-4.853-.412L131.75 5l-1.897 4.475-4.853.412 3.685 3.193-1.107 4.745 4.172-2.518z',
                        className: 'Favorite-fill--selected'
                    }),
                    _react2.default.createElement(
                        'g',
                        { className: 'Favorite-stroke--selected', strokeWidth: '.5', strokeLinecap: 'square' },
                        _react2.default.createElement('path', { d: 'M129 8l-1.5-1.5M135 8l1.5-1.5M127.051 14.054l-1.412 1.271M138.46 15.038L137 14M131.691 18.849l.02-1.12' })
                    )
                ),
                _react2.default.createElement(
                    'g',
                    null,
                    _react2.default.createElement('path', { d: 'M168 0h24v24h-24V0z' }),
                    _react2.default.createElement('path', { d: 'M168 0h24v24h-24V0z' }),
                    _react2.default.createElement(
                        'g',
                        { className: 'Favorite-stroke--selected', strokeWidth: '.8', strokeLinecap: 'square' },
                        _react2.default.createElement('path', { d: 'M177 8l-1.5-1.5M183 8l1.5-1.5M175.051 14.054l-1.576 1.42M186.46 15.038L185 14M180.396 18.849l.008-1.12' })
                    ),
                    _react2.default.createElement('path', {
                        d: 'M180 16.743l5.562 3.357-1.476-6.327L189 9.516l-6.471-.549L180 3l-2.529 5.967-6.471.549 4.914 4.257-1.476 6.327L180 16.743z',
                        className: 'Favorite-fill--selected'
                    })
                ),
                _react2.default.createElement(
                    'g',
                    null,
                    _react2.default.createElement('path', { d: 'M192 0h24v24h-24V0z' }),
                    _react2.default.createElement('path', {
                        d: 'M204 17.27l6.18 3.73-1.64-7.03L214 9.24l-7.19-.61L204 2l-2.81 6.63-7.19.61 5.46 4.73-1.64 7.03 6.18-3.73z',
                        className: 'Favorite-fill--selected'
                    }),
                    _react2.default.createElement('path', { d: 'M192 0h24v24h-24V0z' }),
                    _react2.default.createElement(
                        'g',
                        { className: 'Favorite-stroke--selected', strokeLinecap: 'square' },
                        _react2.default.createElement('path', { d: 'M201 8l-1.5-1.5M207 8l1.5-1.5M199.051 14.054l-1.576 1.42M210.46 15.038L209 14M203.495 18.849l.01-1.12' })
                    )
                ),
                _react2.default.createElement(
                    'g',
                    null,
                    _react2.default.createElement('path', { d: 'M216 0h24v24h-24V0z' }),
                    _react2.default.createElement('path', {
                        d: 'M228 18.324l7.416 4.476-1.968-8.436L240 8.688l-8.628-.732L228 0l-3.372 7.956-8.628.732 6.552 5.676-1.968 8.436L228 18.324z',
                        className: 'Favorite-fill--selected'
                    }),
                    _react2.default.createElement('path', { d: 'M216 0h24v24h-24V0z' })
                ),
                _react2.default.createElement(
                    'g',
                    null,
                    _react2.default.createElement('path', { d: 'M264 0h24v24h-24V0z' }),
                    _react2.default.createElement('path', {
                        className: 'star-filled Favorite-fill--selected',
                        d: 'M276 17.27l6.18 3.73-1.64-7.03L286 9.24l-7.19-.61L276 2l-2.81 6.63-7.19.61 5.46 4.73-1.64 7.03 6.18-3.73z'
                    }),
                    _react2.default.createElement('path', { d: 'M264 0h24v24h-24V0z' })
                ),
                _react2.default.createElement(
                    'g',
                    null,
                    _react2.default.createElement('path', { d: 'M240 0h24v24h-24V0z' }),
                    _react2.default.createElement('path', {
                        d: 'M252 17.797l6.798 4.103-1.804-7.733L263 8.964l-7.909-.671L252 1l-3.091 7.293-7.909.671 6.006 5.203-1.804 7.733L252 17.797z',
                        className: 'Favorite-fill--selected'
                    }),
                    _react2.default.createElement('path', { d: 'M240 0h24v24h-24V0z' })
                ),
                _react2.default.createElement('circle', { className: 'Favorite-stroke--selected', strokeWidth: '.5', cx: '156', cy: '12', r: '8' }),
                _react2.default.createElement('circle', { className: 'Favorite-stroke--selected', strokeWidth: '.3', cx: '180', cy: '12', r: '10' }),
                _react2.default.createElement('circle', { className: 'Favorite-stroke--selected', strokeWidth: '.1', cx: '204', cy: '12', r: '11' }),
                _react2.default.createElement('circle', { className: 'Favorite-stroke--selected', strokeWidth: '.8', cx: '132', cy: '12', r: '7' }),
                _react2.default.createElement('circle', { className: 'Favorite-stroke--selected', cx: '108.5', cy: '12.5', r: '5.5' })
            )
        )
    );
}
/* eslint-enable max-len */
//# sourceMappingURL=Favorite.js.map
