"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.CustomIcons = undefined;

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable max-len, react/prop-types, react/self-closing-comp */

function BasicIcon(props) {
    return _react2.default.cloneElement(props.children, {
        width: props.width,
        height: props.height,
        size: props.width,
        fill: props.fill
    });
}

var CustomIcons = exports.CustomIcons = {
    git: function git(props) {
        return _react2.default.createElement(
            BasicIcon,
            props,
            _react2.default.createElement(
                "svg",
                { width: "24px", height: "24px", viewBox: "0 0 24 24", version: "1.1", xmlns: "http://www.w3.org/2000/svg", xmlnsXlink: "http://www.w3.org/1999/xlink" },
                _react2.default.createElement(
                    "defs",
                    null,
                    _react2.default.createElement("polygon", { id: "path-1", points: "0 24 24 24 24 0 0 0" })
                ),
                _react2.default.createElement(
                    "g",
                    { id: "Symbols", stroke: "none", strokeWidth: "1", fill: "none", fillRule: "evenodd" },
                    _react2.default.createElement(
                        "g",
                        { id: "social-git" },
                        _react2.default.createElement(
                            "g",
                            { id: "Fill-1" },
                            _react2.default.createElement(
                                "mask",
                                { id: "mask-2", fill: "white" },
                                _react2.default.createElement("use", { xlinkHref: "#path-1" })
                            ),
                            _react2.default.createElement("g", { id: "Mask" }),
                            _react2.default.createElement("path", { d: "M23.5471033,10.9311734 L13.0685777,0.452709449 C12.4654989,-0.15090315 11.4868346,-0.15090315 10.8827111,0.452709449 L8.7070308,2.62895358 L11.4669844,5.38922097 C12.1084575,5.17243237 12.8442188,5.3179158 13.35536,5.82906676 C13.8696355,6.3436132 14.013549,7.08539588 13.7915408,7.72923191 L16.4517214,10.3894631 C17.0955451,10.1674507 17.8378361,10.3108446 18.3521115,10.8259134 C19.0703733,11.5439277 19.0703733,12.7080564 18.3521115,13.4265931 C17.6333273,14.1453909 16.469482,14.1453909 15.7504367,13.4265931 C15.2100426,12.8859275 15.0765765,12.0919066 15.3502995,11.4263917 L12.8690315,8.9453376 L12.8690315,15.47407 C13.0440262,15.5607854 13.209357,15.6764931 13.35536,15.8219765 C14.0736218,16.540252 14.0736218,17.7041195 13.35536,18.4234397 C12.6370982,19.141454 11.4724694,19.141454 10.7547299,18.4234397 C10.0364681,17.7041195 10.0364681,16.540252 10.7547299,15.8219765 C10.9320753,15.6446278 11.1378899,15.5103755 11.3570251,15.4205258 L11.3570251,8.8311971 C11.1378899,8.74160856 10.9325977,8.6084011 10.7547299,8.43000759 C10.2106792,7.88620775 10.079825,7.08748541 10.3587718,6.41935861 L7.63773486,3.6977475 L0.452504938,10.8825919 C-0.150834979,11.4867269 -0.150834979,12.4654099 0.452504938,13.0690225 L10.9315529,23.5474864 C11.5348928,24.1508379 12.513296,24.1508379 13.1176807,23.5474864 L23.5471033,13.117604 C24.1509656,12.5139914 24.1509656,11.5345248 23.5471033,10.9311734", fill: props.fill, mask: "url(#mask-2)" })
                        )
                    )
                )
            )
        );
    },
    github: function github(props) {
        return _react2.default.createElement(
            BasicIcon,
            props,
            _react2.default.createElement(
                "svg",
                { width: "24px", height: "24px", viewBox: "0 0 24 24", version: "1.1", xmlns: "http://www.w3.org/2000/svg", xmlnsXlink: "http://www.w3.org/1999/xlink" },
                _react2.default.createElement(
                    "g",
                    { id: "Symbols", stroke: "none", strokeWidth: "1", fill: "none", fillRule: "evenodd" },
                    _react2.default.createElement(
                        "g",
                        { id: "social-github", fill: props.fill },
                        _react2.default.createElement(
                            "g",
                            { id: "social-github-copy" },
                            _react2.default.createElement(
                                "g",
                                { id: "Layer_1" },
                                _react2.default.createElement("path", { d: "M12,0 C5.37321429,0 0,5.5125 0,12.3053571 C0,17.7428571 3.43928571,22.35 8.20714286,23.9785714 C8.28214286,23.9946429 8.34642857,24 8.41071429,24 C8.85535714,24 9.02678571,23.6732143 9.02678571,23.3892857 C9.02678571,23.0946429 9.01607143,22.3232143 9.01071429,21.2946429 C8.56071429,21.3964286 8.15892857,21.4392857 7.8,21.4392857 C5.49107143,21.4392857 4.96607143,19.6446429 4.96607143,19.6446429 C4.41964286,18.225 3.63214286,17.8446429 3.63214286,17.8446429 C2.5875,17.1107143 3.62678571,17.0892857 3.70714286,17.0892857 L3.7125,17.0892857 C4.91785714,17.1964286 5.55,18.3642857 5.55,18.3642857 C6.15,19.4142857 6.95357143,19.7089286 7.67142857,19.7089286 C8.23392857,19.7089286 8.74285714,19.5267857 9.04285714,19.3875 C9.15,18.5946429 9.46071429,18.0535714 9.80357143,17.7428571 C7.14107143,17.4321429 4.33928571,16.3767857 4.33928571,11.6625 C4.33928571,10.3178571 4.80535714,9.21964286 5.57142857,8.3625 C5.44821429,8.05178571 5.03571429,6.79821429 5.68928571,5.10535714 C5.68928571,5.10535714 5.775,5.07857143 5.95714286,5.07857143 C6.39107143,5.07857143 7.37142857,5.24464286 8.98928571,6.36964286 C9.94821429,6.09642857 10.9714286,5.9625 11.9946429,5.95714286 C13.0125,5.9625 14.0410714,6.09642857 15,6.36964286 C16.6178571,5.24464286 17.5982143,5.07857143 18.0321429,5.07857143 C18.2142857,5.07857143 18.3,5.10535714 18.3,5.10535714 C18.9535714,6.79821429 18.5410714,8.05178571 18.4178571,8.3625 C19.1839286,9.225 19.65,10.3232143 19.65,11.6625 C19.65,16.3875 16.8428571,17.4267857 14.1696429,17.7321429 C14.5982143,18.1125 14.9839286,18.8625 14.9839286,20.0089286 C14.9839286,21.6535714 14.9678571,22.9821429 14.9678571,23.3839286 C14.9678571,23.6732143 15.1339286,24 15.5785714,24 C15.6428571,24 15.7178571,23.9946429 15.7928571,23.9785714 C20.5660714,22.35 24,17.7375 24,12.3053571 C24,5.5125 18.6267857,0 12,0 Z", id: "Shape" })
                            )
                        )
                    )
                )
            )
        );
    },
    bitbucket: function bitbucket(props) {
        return _react2.default.createElement(
            BasicIcon,
            props,
            _react2.default.createElement(
                "svg",
                { width: "24px", height: "24px", viewBox: "0 0 24 24", version: "1.1", xmlns: "http://www.w3.org/2000/svg", xmlnsXlink: "http://www.w3.org/1999/xlink" },
                _react2.default.createElement(
                    "g",
                    { id: "Symbols", stroke: "none", strokeWidth: "1", fill: "none", fillRule: "evenodd" },
                    _react2.default.createElement(
                        "g",
                        { id: "social-bitbucket", fill: props.fill },
                        _react2.default.createElement(
                            "g",
                            { id: "Group-9", transform: "translate(1.000000, 0.000000)" },
                            _react2.default.createElement("path", { d: "M10.675677,0 L10.675677,0.000344371741 L10.675677,0 C4.79874928,0 0,1.55879868 0,3.49434005 C0,4.00418242 1.28149311,11.3141614 1.78986699,14.2130827 C2.01778882,15.5132582 5.42300379,17.4193558 10.6728847,17.4193558 L10.6782948,17.403859 L10.6782948,17.4193558 C15.9280012,17.4193558 19.3332162,15.5132582 19.561138,14.2130827 C20.0695119,11.3141614 21.351005,4.00418242 21.351005,3.49434005 C21.3511795,1.55897087 16.5526048,0 10.675677,0 L10.675677,0 Z M10.675677,15.0709127 C8.80151735,15.0709127 7.28215483,13.5716903 7.28215483,11.7227584 C7.28215483,9.87348218 8.80151735,8.37460418 10.675677,8.37460418 C12.5498367,8.37460418 14.0691992,9.87348218 14.0691992,11.7227584 C14.0691992,13.5716903 12.5498367,15.0709127 10.675677,15.0709127 L10.675677,15.0709127 Z M10.6737573,4.57446202 C6.89786396,4.56843551 3.83802212,3.92118883 3.83924375,3.12844508 C3.84046538,2.33570133 6.90275049,1.69809705 10.6786438,1.70412356 C14.4545372,1.70997788 17.514379,2.35722457 17.5131574,3.1501405 C17.5117612,3.94305643 14.4496507,4.58031634 10.6737573,4.57446202 L10.6737573,4.57446202 Z", id: "Shape" }),
                            _react2.default.createElement("path", { d: "M18.3482309,16.6956522 C18.1859282,16.6956522 18.0559115,16.8089505 18.0559115,16.8089505 C18.0559115,16.8089505 15.4269571,18.8629557 10.6755025,18.8631279 C5.92387335,18.8629557 3.29509347,16.8089505 3.29509347,16.8089505 C3.29509347,16.8089505 3.16490229,16.6956522 3.00277413,16.6956522 C2.8088835,16.6956522 2.62511498,16.8241028 2.62511498,17.107693 C2.62511498,17.1376533 2.62808181,17.1676136 2.63366641,17.1968852 C3.04169186,19.3516192 3.33977034,20.8804576 3.39212604,21.1130807 C3.74831935,22.6980516 6.8908832,23.8940547 10.675328,23.8942269 L10.675328,23.8942269 L10.6755025,23.8942269 L10.675677,23.8942269 L10.675677,23.8942269 C14.4602963,23.8940547 17.6026857,22.6980516 17.958879,21.1130807 C18.0112347,20.8802854 18.3093131,19.3516192 18.7173386,17.1968852 C18.7229232,17.1676136 18.72589,17.1376533 18.72589,17.107693 C18.72589,16.8241028 18.541947,16.6956522 18.3482309,16.6956522 L18.3482309,16.6956522 Z", id: "Shape" }),
                            _react2.default.createElement("ellipse", { id: "Oval", cx: "10.6755025", cy: "11.6779513", rx: "1.70068777", ry: "1.67795131" })
                        )
                    )
                )
            )
        );
    }
};
//# sourceMappingURL=IconButtonStoryHelpers.js.map
