'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _Toaster = require('../components/Toaster');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Created by cmeyers on 8/17/16.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var ToasterTester = function (_Component) {
    _inherits(ToasterTester, _Component);

    function ToasterTester() {
        _classCallCheck(this, ToasterTester);

        var _this = _possibleConstructorReturn(this, (ToasterTester.__proto__ || Object.getPrototypeOf(ToasterTester)).call(this));

        _this.toasts = [];
        _this.counter = 0;
        return _this;
    }

    _createClass(ToasterTester, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
            if (this.props.toasts) {
                this.toasts = this.toasts.concat(this.props.toasts);
            }
        }
    }, {
        key: '_addToast',
        value: function _addToast() {
            var id = Math.random() * Math.pow(10, 16);
            var counter = this.counter++;

            this.toasts.push({
                id: id,
                text: 'Hello World Hello World Hello World Hello World ' + counter,
                action: 'Action'
            });
            this.forceUpdate();
        }
    }, {
        key: '_onActionClick',
        value: function _onActionClick(toast) {
            var index = this.toasts.indexOf(toast);
            this.toasts.splice(index, 1);
            this.forceUpdate();
        }
    }, {
        key: '_onDismiss',
        value: function _onDismiss(toast) {
            var index = this.toasts.indexOf(toast);

            if (index >= 0) {
                this.toasts.splice(index, 1);
                this.forceUpdate();
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            var containerStyle = { position: 'absolute', bottom: 0, minWidth: 400, height: 250 };
            var toasterStyle = { position: 'absolute', top: 0, bottom: 50, width: 400, backgroundColor: '#eee' };
            var buttonStyle = { position: 'absolute', bottom: 0 };

            return _react2.default.createElement(
                'div',
                { style: containerStyle },
                _react2.default.createElement(
                    'div',
                    { style: toasterStyle },
                    _react2.default.createElement(_Toaster.Toaster, {
                        toasts: this.toasts,
                        onActionClick: function onActionClick(toast) {
                            return _this2._onActionClick(toast);
                        },
                        onDismiss: function onDismiss(toast) {
                            return _this2._onDismiss(toast);
                        },
                        dismissDelay: this.props.dismissDelay
                    })
                ),
                _react2.default.createElement(
                    'button',
                    {
                        onClick: function onClick() {
                            return _this2._addToast();
                        },
                        style: buttonStyle
                    },
                    'Add Toast'
                )
            );
        }
    }]);

    return ToasterTester;
}(_react.Component);

ToasterTester.propTypes = {
    toasts: _react.PropTypes.array,
    dismissDelay: _react.PropTypes.number
};

(0, _storybook.storiesOf)('Toaster', module).add('default', function () {
    return _react2.default.createElement(ToasterTester, null);
}).add('with 1 toast', function () {
    var toasts = [{
        id: Math.random() * Math.pow(10, 16),
        text: 'Hello World',
        action: 'Toast!',
        dismissDelay: 10000
    }];

    return _react2.default.createElement(ToasterTester, { toasts: toasts });
}).add('with caption and error', function () {
    var toasts = [{
        id: Math.random() * Math.pow(10, 16),
        style: 'error',
        caption: 'Favorites Error',
        text: 'Failed to register favorite'
    }];

    return _react2.default.createElement(ToasterTester, { toasts: toasts });
});
//# sourceMappingURL=ToasterStories.js.map
