'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.polarToCartesian = polarToCartesian;
exports.describeArcAsPath = describeArcAsPath;


//
// Common Helper functions for building SVGs. Could include simple math funcs as well as higher-order components.
//

function polarToCartesian(centerX, centerY, radius, angleInDegrees) {
    var angleInRadians = (angleInDegrees - 90) * Math.PI / 180.0;

    return {
        x: centerX + radius * Math.cos(angleInRadians),
        y: centerY + radius * Math.sin(angleInRadians)
    };
}

function describeArcAsPath(x, y, radius, startAngle, endAngle) {
    var start = polarToCartesian(x, y, radius, endAngle);
    var end = polarToCartesian(x, y, radius, startAngle);

    var arcSweep = endAngle - startAngle <= 180 ? '0' : '1';

    var d = ['M', start.x, start.y, 'A', radius, radius, 0, arcSweep, 0, end.x, end.y].join(' ');

    return d;
}

// Also export an OBJ of classes + funs, like Math
var SVG = {
    polarToCartesian: polarToCartesian,
    describeArcAsPath: describeArcAsPath
};

exports.default = SVG;
//# sourceMappingURL=SVG.js.map
