'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Popover = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _FloatingElement = require('./FloatingElement');

var _Position = require('./Position');

var _ = require('.');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Popover = exports.Popover = function (_Component) {
    _inherits(Popover, _Component);

    function Popover() {
        var _ref;

        var _temp, _this, _ret;

        _classCallCheck(this, Popover);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Popover.__proto__ || Object.getPrototypeOf(Popover)).call.apply(_ref, [this].concat(args))), _this), _this.modalScreenClicked = function () {
            var onDismiss = _this.props.onDismiss;


            if (onDismiss) {
                onDismiss();
            }
        }, _this.keyPressed = function (event) {
            var _this$props = _this.props,
                onDismiss = _this$props.onDismiss,
                ignoreEscapeKey = _this$props.ignoreEscapeKey;


            if (!ignoreEscapeKey && onDismiss && event.keyCode === 27) {
                onDismiss();
            }
        }, _temp), _possibleConstructorReturn(_this, _ret);
    }
    //--------------------------------------
    //  User Interaction
    //--------------------------------------

    _createClass(Popover, [{
        key: 'render',


        //--------------------------------------
        //  React Lifecycle
        //--------------------------------------

        value: function render() {
            var _props = this.props,
                children = _props.children,
                style = _props.style;

            var position = (0, _Position.sanitizePosition)(this.props.position);
            var pointClassName = 'Popover-point Popover-point--' + position;
            var positionFunction = _Position.PositionFunctions[position];

            return _react2.default.createElement(
                _.ModalContainer,
                { onScreenClick: this.modalScreenClicked },
                _react2.default.createElement(
                    _FloatingElement.FloatingElement,
                    { targetElement: this.props.targetElement, positionFunction: positionFunction },
                    _react2.default.createElement(
                        'div',
                        { className: 'Popover-wrapper', style: style },
                        _react2.default.createElement(
                            'svg',
                            { className: pointClassName, viewBox: '0 0 2 2', width: '20', height: '20' },
                            _react2.default.createElement('path', { d: 'M 1 0 L 2 1 L 1 2 L 0 1 L 1 0' })
                        ),
                        _react2.default.createElement(
                            'div',
                            { className: 'Popover-content' },
                            children
                        )
                    )
                )
            );
        }
    }, {
        key: 'componentDidMount',
        value: function componentDidMount() {
            document.addEventListener('keyup', this.keyPressed, false);
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            document.removeEventListener('keyup', this.keyPressed, false);
        }
    }]);

    return Popover;
}(_react.Component);

Popover.propTypes = {
    targetElement: _react.PropTypes.object,
    position: _react.PropTypes.oneOf(_Position.positions),
    onDismiss: _react.PropTypes.func,
    ignoreEscapeKey: _react.PropTypes.bool,
    style: _react.PropTypes.object,
    children: _react.PropTypes.node
};
//# sourceMappingURL=Popover.js.map
