'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FilterableList = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _lodash = require('lodash.debounce');

var _lodash2 = _interopRequireDefault(_lodash);

var _List = require('./List');

var _TextInput = require('./forms/TextInput');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function defaultFilterFunction(text, item) {
    return item && item.toString().indexOf(text) >= 0;
}

/**
 * Control that displays a List of items and allows for selection.
 * Includes a text field above for quick filtering of items in the list.
 * Provide a filterFunction that determines whether item should be displayed with text.
 * See "List" component for more details.
 *
 * @property {string} className additional "class" to add to outermost element (alongside "FilterableList")
 * @property {array} children React children
 * @property {Object} style React style object to be applied to outer element.
 * @property {array} [data] data to render in the list.
 * @property {Function} [labelFunction] converts each object to a string in the default renderer.
 * @property {Function} [keyFunction]
 * @property {boolean} [defaultStyles] set "false" to remove all default styling from the List.
 * @property {Object} [defaultSelection] item to select in the list by default
 * @property {Function} [onItemSelect] callback when an item is selected, receiving listIndex and listItem.
 *
 * @property {Object} listStyle React style object to be applied to child List.
 * @property {Function} filterFunction receives text, item; return true/false to show each item
 * @property {string} placeholder text to display in filter input when empty
 * @property {string} emptyText text to display when no matches occur
 */

var FilterableList = exports.FilterableList = function (_React$Component) {
    _inherits(FilterableList, _React$Component);

    function FilterableList(props) {
        _classCallCheck(this, FilterableList);

        var _this = _possibleConstructorReturn(this, (FilterableList.__proto__ || Object.getPrototypeOf(FilterableList)).call(this, props));

        _this._onFilterChange = (0, _lodash2.default)(function (text) {
            _this.setState({
                text: text
            });
        }, 250);


        _this.state = {};
        return _this;
    }

    _createClass(FilterableList, [{
        key: 'render',
        value: function render() {
            var _this2 = this;

            // passthrough props for List
            var _props = this.props,
                keyFunction = _props.keyFunction,
                labelFunction = _props.labelFunction,
                listStyle = _props.listStyle,
                defaultStyles = _props.defaultStyles,
                defaultSelection = _props.defaultSelection,
                onItemSelect = _props.onItemSelect;
            var _props2 = this.props,
                data = _props2.data,
                disabled = _props2.disabled,
                emptyText = _props2.emptyText,
                filterFunction = _props2.filterFunction,
                placeholder = _props2.placeholder,
                style = _props2.style;
            var text = this.state.text;

            var filtered = data ? data.filter(function (item) {
                return !text || filterFunction(text, item);
            }) : [];
            var noMatches = text && filtered.length === 0;

            var listProps = {
                labelFunction: labelFunction,
                keyFunction: keyFunction,
                defaultStyles: defaultStyles,
                defaultSelection: defaultSelection,
                onItemSelect: onItemSelect
            };

            var outerClass = this.props.className || '';

            return _react2.default.createElement(
                'div',
                { className: 'FilterableList ' + outerClass, style: style },
                _react2.default.createElement(_TextInput.TextInput, { placeholder: placeholder, disabled: disabled, onChange: function onChange(text) {
                        return _this2._onFilterChange(text);
                    }, iconLeft: 'ActionSearch' }),
                noMatches && emptyText && _react2.default.createElement(
                    'div',
                    { className: 'FilterableList-empty-text' },
                    emptyText
                ),
                !noMatches && _react2.default.createElement(
                    _List.List,
                    _extends({}, listProps, { disabled: disabled, className: 'FilterableList-List', data: filtered, style: listStyle }),
                    this.props.children
                )
            );
        }
    }]);

    return FilterableList;
}(_react2.default.Component);

FilterableList.defaultProps = {
    style: {},
    listStyle: {},
    filterFunction: defaultFilterFunction,
    placeholder: 'Search...',
    emptyText: 'No matches.'
};


FilterableList.propTypes = {
    // from List
    className: _react.PropTypes.string,
    children: _react.PropTypes.element,
    style: _react.PropTypes.object,
    data: _react.PropTypes.array,
    disabled: _react.PropTypes.bool,
    labelFunction: _react.PropTypes.func,
    keyFunction: _react.PropTypes.func,
    defaultStyles: _react.PropTypes.bool,
    defaultSelection: _react.PropTypes.any,
    onItemSelect: _react.PropTypes.func,
    // for FilterableList
    listStyle: _react.PropTypes.object,
    filterFunction: _react.PropTypes.func,
    placeholder: _react.PropTypes.string,
    emptyText: _react.PropTypes.string
};
//# sourceMappingURL=FilterableList.js.map
