/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.domain.VirtualGuestBlockDeviceTemplateGroup;

@RequestFilters(value={BasicAuthentication.class})
@Path(value="/v{jclouds.api-version}")
@Consumes(value={"application/json"})
public interface AccountApi {
    public static final String GUEST_MASK = "children.blockDevices.diskImage.softwareReferences.softwareDescription";
    public static final String LIST_GUEST_MASK = "powerState;operatingSystem.passwords;datacenter;billingItem;blockDevices.diskImage;tagReferences.tag.name";

    @Named(value="Account:listVirtualGuest")
    @GET
    @Path(value="/SoftLayer_Account/VirtualGuests")
    @QueryParams(keys={"objectMask"}, values={"powerState;operatingSystem.passwords;datacenter;billingItem;blockDevices.diskImage;tagReferences.tag.name"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<VirtualGuest> listVirtualGuests();

    @Named(value="Account:getBlockDeviceTemplateGroups")
    @GET
    @Path(value="/SoftLayer_Account/getBlockDeviceTemplateGroups")
    @QueryParams(keys={"objectMask"}, values={"children.blockDevices.diskImage.softwareReferences.softwareDescription"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<VirtualGuestBlockDeviceTemplateGroup> getBlockDeviceTemplateGroups();
}

