/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.auto.value.AutoValue;
import java.util.Date;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.softlayer.domain.AutoValue_Subnet;
import org.jclouds.softlayer.domain.AutoValue_Subnet_CreateDatacenterName;
import org.jclouds.softlayer.domain.AutoValue_Subnet_CreateSubnet;
import org.jclouds.softlayer.domain.AutoValue_Subnet_DeleteSubnet;

@AutoValue
public abstract class Subnet {
    public abstract String boradcastAddress();

    public abstract int cidr();

    public abstract String gateway();

    public abstract long id();

    public abstract boolean isCustomerOwned();

    public abstract boolean isCustomerRoutable();

    @Nullable
    public abstract Date modifyDate();

    public abstract String netmask();

    public abstract String networkIdentifier();

    public abstract long networkVlanId();

    @Nullable
    public abstract String note();

    public abstract String sortOrder();

    @Nullable
    public abstract String subnetType();

    public abstract String totalIpAddresses();

    public abstract String usableIpAddressCount();

    public abstract int version();

    @Nullable
    public abstract String addressSpace();

    @SerializedNames(value={"broadcastAddress", "cidr", "gateway", "id", "isCustomerOwned", "isCustomerRoutable", "modifyDate", "netmask", "networkIdentifier", "networkVlanId", "note", "sortOrder", "subnetType", "totalIpAddresses", "usableIpAddressCount", "version", "addressSpace"})
    public static Subnet create(String broadcastAddress, int cidr, String gateway, long id, boolean isCustomerOwned, boolean isCustomerRoutable, Date modifyDate, String netmask, String networkIdentifier, long networkVlanId, String note, String sortOrder, String subnetType, String totalIpAddresses, String usableIpAddressCount, int version, String addressSpace) {
        return new AutoValue_Subnet(broadcastAddress, cidr, gateway, id, isCustomerOwned, isCustomerRoutable, modifyDate, netmask, networkIdentifier, networkVlanId, note, sortOrder, subnetType, totalIpAddresses, usableIpAddressCount, version, addressSpace);
    }

    Subnet() {
    }

    @AutoValue
    public static abstract class CreateDatacenterName {
        public abstract String name();

        @SerializedNames(value={"name"})
        public static CreateDatacenterName create(String name) {
            return CreateDatacenterName.builder().name(name).build();
        }

        CreateDatacenterName() {
        }

        public static Builder builder() {
            return new AutoValue_Subnet_CreateDatacenterName.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder name(String var1);

            abstract CreateDatacenterName autoBuild();

            public CreateDatacenterName build() {
                return this.autoBuild();
            }
        }
    }

    @AutoValue
    public static abstract class DeleteSubnet {
        public abstract long id();

        @SerializedNames(value={"id"})
        private static DeleteSubnet create(long id) {
            return DeleteSubnet.builder().id(id).build();
        }

        public static Builder builder() {
            return new AutoValue_Subnet_DeleteSubnet.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder id(long var1);

            abstract DeleteSubnet autoBuild();

            public DeleteSubnet build() {
                return this.autoBuild();
            }
        }
    }

    @AutoValue
    public static abstract class CreateSubnet {
        public abstract String networkIdentifier();

        public abstract String note();

        public abstract int cidr();

        @SerializedNames(value={"networkIdentifier", "note", "cidr"})
        private static CreateSubnet create(String networkIdentifier, String note, int cidr) {
            return CreateSubnet.builder().networkIdentifier(networkIdentifier).cidr(cidr).note(note).build();
        }

        public static Builder builder() {
            return new AutoValue_Subnet_CreateSubnet.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder networkIdentifier(String var1);

            public abstract Builder note(String var1);

            public abstract Builder cidr(int var1);

            abstract CreateSubnet autoBuild();

            public CreateSubnet build() {
                return this.autoBuild();
            }
        }
    }
}

