/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Set;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;

@Singleton
public class SplitNewlines
implements Function<HttpResponse, Set<String>> {
    private final ReturnStringIf2xx returnStringIf200;

    @Inject
    SplitNewlines(ReturnStringIf2xx returnStringIf200) {
        this.returnStringIf200 = returnStringIf200;
    }

    public Set<String> apply(HttpResponse response) {
        String payload = this.returnStringIf200.apply(response);
        return payload == null ? ImmutableSet.of() : ImmutableSet.copyOf((Iterable)Splitter.on((char)'\n').omitEmptyStrings().split((CharSequence)payload));
    }
}

