/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import org.jclouds.elasticstack.domain.BlockDevice;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.IDEDevice;
import org.jclouds.elasticstack.domain.MediaType;
import org.jclouds.elasticstack.domain.SCSIDevice;

@Singleton
public class MapToDevices
implements Function<Map<String, String>, Map<String, ? extends Device>> {
    private final Function<Device, String> deviceToId;

    @Inject
    public MapToDevices(Function<Device, String> deviceToId) {
        this.deviceToId = deviceToId;
    }

    public Map<String, ? extends Device> apply(Map<String, String> from) {
        ImmutableSet.Builder devices = ImmutableSet.builder();
        this.addIDEDevices(from, (ImmutableSet.Builder<Device>)devices);
        this.addSCSIDevices(from, (ImmutableSet.Builder<Device>)devices);
        this.addBlockDevices(from, (ImmutableSet.Builder<Device>)devices);
        return Maps.uniqueIndex((Iterable)devices.build(), this.deviceToId);
    }

    protected void addBlockDevices(Map<String, String> from, ImmutableSet.Builder<Device> devices) {
        for (int index : new int[]{0, 1, 2, 3, 4, 5, 6, 7}) {
            String key = String.format("block:0:%d", index);
            if (!from.containsKey(key)) break;
            devices.add((Object)this.populateBuilder(new BlockDevice.Builder(index), key, from).build());
        }
    }

    protected void addSCSIDevices(Map<String, String> from, ImmutableSet.Builder<Device> devices) {
        for (int unit : new int[]{0, 1, 2, 3, 4, 5, 6, 7}) {
            String key = String.format("scsi:0:%d", unit);
            if (!from.containsKey(key)) break;
            devices.add((Object)this.populateBuilder(new SCSIDevice.Builder(unit), key, from).build());
        }
    }

    protected void addIDEDevices(Map<String, String> from, ImmutableSet.Builder<Device> devices) {
        block0: for (int bus : new int[]{0, 1}) {
            for (int unit : new int[]{0, 1}) {
                String key = String.format("ide:%d:%d", bus, unit);
                if (!from.containsKey(key)) break block0;
                devices.add((Object)this.populateBuilder(new IDEDevice.Builder(bus, unit), key, from).build());
            }
        }
    }

    protected Device.Builder populateBuilder(Device.Builder deviceBuilder, String key, Map<String, String> from) {
        deviceBuilder.uuid(from.get(key));
        if (from.containsKey(key + ":media")) {
            deviceBuilder.mediaType(MediaType.fromValue(from.get(key + ":media")));
        }
        return deviceBuilder;
    }

    @Singleton
    public static class DeviceToId
    implements Function<Device, String> {
        public String apply(Device input) {
            return input.getId();
        }
    }
}

