/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Set;
import org.jclouds.elasticstack.domain.StandardDrive;
import org.jclouds.elasticstack.functions.ListOfKeyValuesDelimitedByBlankLinesToListOfMaps;
import org.jclouds.elasticstack.functions.MapToStandardDrive;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;

@Singleton
public class ListOfKeyValuesDelimitedByBlankLinesToStandardDriveSet
implements Function<HttpResponse, Set<StandardDrive>> {
    private final ReturnStringIf2xx returnStringIf2xx;
    private final ListOfKeyValuesDelimitedByBlankLinesToListOfMaps mapConverter;
    private final MapToStandardDrive mapToStandardDrive;

    @Inject
    ListOfKeyValuesDelimitedByBlankLinesToStandardDriveSet(ReturnStringIf2xx returnStringIf2xx, ListOfKeyValuesDelimitedByBlankLinesToListOfMaps mapConverter, MapToStandardDrive mapToStandardDrive) {
        this.returnStringIf2xx = (ReturnStringIf2xx)Preconditions.checkNotNull((Object)returnStringIf2xx, (Object)"returnStringIf2xx");
        this.mapConverter = (ListOfKeyValuesDelimitedByBlankLinesToListOfMaps)Preconditions.checkNotNull((Object)mapConverter, (Object)"mapConverter");
        this.mapToStandardDrive = (MapToStandardDrive)Preconditions.checkNotNull((Object)mapToStandardDrive, (Object)"mapToStandardDrive");
    }

    public Set<StandardDrive> apply(HttpResponse response) {
        String text = Strings.nullToEmpty((String)this.returnStringIf2xx.apply(response));
        if (text.trim().equals("")) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.mapConverter.apply(text), (Function)this.mapToStandardDrive));
    }
}

