/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.modules;

import jakarta.inject.Singleton;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jclouds.encryption.internal.JCECrypto;

@Singleton
public class JenkinsBouncyCastleCrypto
extends JCECrypto {
    private static final BouncyCastleProvider BC_PROVIDER;

    public JenkinsBouncyCastleCrypto() throws NoSuchAlgorithmException, CertificateException {
        super((Provider)BC_PROVIDER);
    }

    public Cipher cipher(String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException {
        return super.cipher("RSA".equals(algorithm) ? "RSA/NONE/PKCS1Padding" : algorithm);
    }

    static {
        BouncyCastleProvider myBCProvider = new BouncyCastleProvider();
        Provider installedProvider = Security.getProvider(myBCProvider.getName());
        BC_PROVIDER = installedProvider != null && installedProvider.getClass().equals(BouncyCastleProvider.class) ? (BouncyCastleProvider)installedProvider : myBCProvider;
    }
}

