/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.internal;

import com.trilead.ssh2.crypto.PEMDecoder;
import com.trilead.ssh2.signature.DSAKeyAlgorithm;
import com.trilead.ssh2.signature.ECDSAKeyAlgorithm;
import com.trilead.ssh2.signature.KeyAlgorithm;
import com.trilead.ssh2.signature.KeyAlgorithmManager;
import com.trilead.ssh2.signature.RSAKeyAlgorithm;
import java.io.IOException;
import java.security.KeyPair;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;

public final class SSHPublicKeyExtractor {
    public static String extract(String pem, String passPhrase) throws IOException {
        KeyPair kp = PEMDecoder.decodeKeyPair((char[])pem.toCharArray(), (String)passPhrase);
        if (kp.getPrivate() instanceof RSAPrivateKey) {
            return "ssh-rsa " + Base64.getEncoder().encodeToString(new RSAKeyAlgorithm().encodePublicKey((RSAPublicKey)kp.getPublic()));
        }
        if (kp.getPrivate() instanceof DSAPrivateKey) {
            return "ssh-dss " + Base64.getEncoder().encodeToString(new DSAKeyAlgorithm().encodePublicKey((DSAPublicKey)kp.getPublic()));
        }
        if (kp.getPrivate() instanceof ECPrivateKey) {
            return "ecdsa-sha2-nistp256 " + Base64.getEncoder().encodeToString(new ECDSAKeyAlgorithm.ECDSASha2Nistp256().encodePublicKey((ECPublicKey)kp.getPublic()));
        }
        if (kp.getPrivate() instanceof EdDSAPrivateKey) {
            for (KeyAlgorithm ka : KeyAlgorithmManager.getSupportedAlgorithms()) {
                if (!ka.getKeyFormat().equals("ssh-ed25519")) continue;
                return "ssh-ed25519 " + Base64.getEncoder().encodeToString(ka.encodePublicKey(kp.getPublic()));
            }
        }
        throw new IOException("unsupported key format: " + kp.getPrivate().toString());
    }
}

